/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.v3;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.recurly.v3.ApiException;
import com.recurly.v3.RecurlyException;
import com.recurly.v3.Request;
import com.recurly.v3.exception.ExceptionFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class JsonSerializer {
    private final Gson gsonSerializer = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
    private final Gson gsonDeserializer = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(DateTime.class, (Object)new DateDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)new RecurlyEnumTypeAdapterFactory()).create();

    public <T> T deserialize(String responseBody, Type resourceClass) {
        return (T)this.gsonDeserializer.fromJson(responseBody, resourceClass);
    }

    public <T extends RecurlyException> T deserializeError(String responseBody) {
        ApiException apiException = (ApiException)this.gsonDeserializer.fromJson(responseBody, ApiException.class);
        return ExceptionFactory.getExceptionClass(apiException);
    }

    public String serialize(Request body) {
        if (body == null) {
            return "";
        }
        return this.gsonSerializer.toJson((Object)body);
    }

    private class DateDeserializer
    implements JsonDeserializer<DateTime> {
        private DateDeserializer() {
        }

        public DateTime deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            return DateTime.parse((String)element.getAsString());
        }
    }

    private class RecurlyEnumTypeAdapterFactory
    implements TypeAdapterFactory {
        private RecurlyEnumTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(rawType) || rawType == Enum.class) {
                return null;
            }
            if (!rawType.isEnum()) {
                rawType = rawType.getSuperclass();
            }
            return new RecurlyEnumTypeAdapter(rawType);
        }
    }

    private static final class RecurlyEnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public RecurlyEnumTypeAdapter(Class<T> classOfT) {
            try {
                for (Enum constant : (Enum[])classOfT.getEnumConstants()) {
                    String name = constant.name();
                    SerializedName annotation = classOfT.getField(name).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                        for (String alternate : annotation.alternate()) {
                            this.nameToConstant.put(alternate, constant);
                        }
                    }
                    this.nameToConstant.put(name, constant);
                    this.constantToName.put(constant, name);
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Enum constant = (Enum)this.nameToConstant.get(in.nextString());
            if (constant == null) {
                return (T)((Enum)this.nameToConstant.get("UNDEFINED"));
            }
            return (T)constant;
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value(value == null ? null : this.constantToName.get(value));
        }
    }
}

