/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.v3;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.recurly.v3.BaseClient;
import com.recurly.v3.Resource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class Pager<T extends Resource>
implements Iterable<T> {
    @SerializedName(value="has_more")
    @Expose
    private boolean more;
    @SerializedName(value="next")
    @Expose
    private String next;
    @Expose
    private List<T> data;
    private BaseClient client;
    private Type parameterizedType;
    private HashMap<String, Object> queryParams;
    private boolean paramsConsumed;

    public Pager(String path, HashMap<String, Object> queryParams, BaseClient client, Type parameterizedType) {
        this.next = path;
        this.queryParams = queryParams;
        this.client = client;
        this.data = new ArrayList<T>();
        this.parameterizedType = parameterizedType;
        this.more = true;
    }

    public PagerIterator iterator() {
        if (this.data.size() == 0 && this.hasMore()) {
            this.getNextPage();
        }
        return new PagerIterator(this.data.toArray(), this);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        while (this.next != null) {
            this.getNextPage();
            for (Resource t : this) {
                action.accept(t);
            }
        }
    }

    public void eachItem(Consumer<? super T> action) {
        this.forEach(action);
    }

    public boolean hasMore() {
        return this.more;
    }

    public String getNext() {
        return this.next;
    }

    public List<T> getData() {
        return this.data;
    }

    public T getFirst() {
        HashMap firstParams = (HashMap)this.queryParams.clone();
        firstParams.put("limit", 1);
        Pager pager = (Pager)this.client.makeRequest("GET", this.next, firstParams, this.parameterizedType);
        PagerIterator iterator = pager.iterator();
        if (iterator.hasNext()) {
            return (T)((Resource)iterator.next());
        }
        return null;
    }

    public int getCount() {
        return this.client.getRecordCount(this.next, this.queryParams);
    }

    public void getNextPage() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Pager pager = (Pager)this.client.makeRequest("GET", this.next, this.consumeParams(), this.parameterizedType);
        this.clone(pager);
    }

    private void clone(Pager<T> pager) {
        this.next = pager.getNext();
        this.more = pager.hasMore();
        this.data = pager.getData();
    }

    private HashMap<String, Object> consumeParams() {
        if (this.paramsConsumed) {
            return null;
        }
        this.paramsConsumed = true;
        return this.queryParams;
    }

    private class PagerIterator
    implements Iterator {
        private int position = 0;
        private Object[] data;
        private Pager<T> pager;

        public PagerIterator(Object[] data, Pager<T> pager2) {
            this.data = data;
            this.pager = pager2;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.data.length || this.pager.hasMore();
        }

        public Object next() {
            if (this.position == this.data.length && this.pager.hasMore()) {
                this.pager.getNextPage();
                this.data = this.pager.getData().toArray();
                this.position = 0;
            }
            return this.data[this.position++];
        }
    }
}

