/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.v3.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderInterceptor
implements Interceptor {
    private final String apiVersion;
    private final String authToken;
    private static String USER_AGENT = HeaderInterceptor.buildUserAgent();

    public HeaderInterceptor(String authToken, String apiVersion) {
        this.apiVersion = apiVersion;
        this.authToken = authToken;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder builder = original.newBuilder().header("Authorization", this.authToken).header("Accept", "application/vnd.recurly." + this.apiVersion).header("Content-Type", "application/json").header("User-Agent", USER_AGENT);
        Request request = builder.build();
        return chain.proceed(request);
    }

    private static String buildUserAgent() {
        String defaultVersion = "3.?.?";
        String defaultJvmInfo = "?";
        Properties properties = new Properties();
        try {
            InputStream inputStream = HeaderInterceptor.class.getResourceAsStream("/version.properties");
            if (inputStream != null) {
                properties.load(inputStream);
                String version = properties.getProperty("version", "3.?.?");
                String jvmInfo = System.getProperty("java.version", "?");
                return String.format("Recurly/%s; java %s", version, jvmInfo);
            }
        }
        catch (Exception e) {
            System.out.println("[Recurly][WARNING] " + e.getStackTrace().toString());
        }
        System.out.println("[Recurly][WARNING] Could not set user agent header.");
        return String.format("Recurly/%s; java %s", "3.?.?", "?");
    }
}

