/*
 * Decompiled with CFR 0.152.
 */
package com.recursivity.commons;

import java.net.InetAddress;
import java.security.SecureRandom;

public class UUIDGenerator {
    private static UUIDGenerator generator = null;
    private SecureRandom seeder;
    private String midValue;

    private UUIDGenerator() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            String string = UUIDGenerator.hexFormat(UUIDGenerator.getInt(byArray), 8);
            String string2 = UUIDGenerator.hexFormat(System.identityHashCode(this), 8);
            this.midValue = string + string2;
            this.seeder = new SecureRandom();
            int n = this.seeder.nextInt();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static synchronized UUIDGenerator getInstance() {
        if (generator == null) {
            generator = new UUIDGenerator();
        }
        return generator;
    }

    private String generateInternal() {
        long l = System.currentTimeMillis();
        int n = (int)l & 0xFFFFFFFF;
        int n2 = this.seeder.nextInt();
        return UUIDGenerator.hexFormat(n, 8) + this.midValue + UUIDGenerator.hexFormat(n2, 8);
    }

    public static String generate() {
        return UUIDGenerator.getInstance().generateInternal();
    }

    private static String hexFormat(int n, int n2) {
        String string = Integer.toHexString(n);
        return UUIDGenerator.padHex(string, n2) + string;
    }

    private static String padHex(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < n) {
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    private static int getInt(byte[] byArray) {
        int n = 0;
        int n2 = 24;
        int n3 = 0;
        while (n2 >= 0) {
            int n4 = byArray[n3] & 0xFF;
            n += n4 << n2;
            n2 -= 8;
            ++n3;
        }
        return n;
    }
}

