/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.Any;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.cases.ExcludingCase;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public interface Case<T> {
    public Set<Subcase<T>> getSubcases();

    default public Case<T> or(Case<T> other) {
        return Any.of(this, other);
    }

    default public Case<T> orNull() {
        return Any.nullableOf(this);
    }

    default public Case<T> excluding(T value) {
        return this.excluding((Iterable<T>)Collections.singleton(value));
    }

    default public Case<T> excluding(T ... values) {
        return this.excluding((Iterable<T>)(values == null ? null : Arrays.asList(values)));
    }

    default public Case<T> excluding(Iterable<T> values) {
        return new ExcludingCase<T>(this, values);
    }

    default public T generateAnyOnce() {
        return this.generateAnyOnce(new Random());
    }

    default public T generateAnyOnce(Random random) {
        FuzzyPreconditions.checkNotNull(random);
        Set<Subcase<T>> subcases = this.getSubcases();
        if (subcases == null || subcases.isEmpty()) {
            throw new IllegalStateException(String.format("Case of type %s generated zero suppliers.", this.getClass()));
        }
        return ((Subcase)subcases.stream().findAny().orElse(null)).generate(random);
    }

    default public Set<T> generateAllOnce() {
        return this.generateAllOnce(new Random());
    }

    default public Set<T> generateAllOnce(Random random) {
        FuzzyPreconditions.checkNotNull(random);
        Set<Subcase<T>> subcases = this.getSubcases();
        if (subcases == null || subcases.isEmpty()) {
            throw new IllegalStateException(String.format("Case of type %s generated zero suppliers.", this.getClass()));
        }
        return subcases.stream().map(s -> s.generate(random)).collect(Collectors.toSet());
    }
}

