/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.pairwise.Pairwise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public enum CaseCompositionMode {
    EACH_SUBCASE_AT_LEAST_ONCE(baseCases -> {
        ArrayList<Subcase[]> permutations = new ArrayList<Subcase[]>();
        int[] indices = new int[baseCases.length];
        int completed = 0;
        Subcase[][] suppliers = new Subcase[baseCases.length][];
        for (int i = 0; i < baseCases.length; ++i) {
            Set<Subcase<Subcase>> subcases = baseCases[i].getSubcases();
            Subcase[] subcasesArray = subcases.toArray(new Subcase[0]);
            suppliers[i] = subcasesArray;
        }
        while (completed < baseCases.length) {
            Subcase[] subcase = new Subcase[baseCases.length];
            for (int i = 0; i < baseCases.length; ++i) {
                subcase[i] = suppliers[i][indices[i] % suppliers[i].length];
                int n = i;
                indices[n] = indices[n] + 1;
                if (indices[n] != suppliers[i].length) continue;
                ++completed;
            }
            permutations.add(subcase);
        }
        return (Subcase[][])permutations.toArray((T[])new Subcase[0][]);
    }),
    PAIRWISE_PERMUTATIONS_OF_SUBCASES(baseCases -> {
        List parameters = Arrays.stream(baseCases).map(Case::getSubcases).collect(Collectors.toList());
        Pairwise p = new Pairwise(parameters);
        Stack<List<Object>> permutations = p.generate();
        Subcase[][] subcases = new Subcase[permutations.size()][];
        int i = 0;
        for (List list : permutations) {
            Subcase[] suppliers = new Subcase[baseCases.length];
            for (int j = 0; j < baseCases.length; ++j) {
                suppliers[j] = (Subcase)list.get(j);
            }
            subcases[i++] = suppliers;
        }
        return subcases;
    });

    final Algorithm algorithm;

    private CaseCompositionMode(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    static interface Algorithm {
        public Subcase[][] apply(Case[] var1);
    }
}

