/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.CaseCompositionMode;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.FuzzyUtil;
import com.redfin.fuzzy.Subcase;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Cases {
    public static <OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case[] baseCases, BiFunction<Random, Object[], OUTPUT> composition) {
        FuzzyPreconditions.checkNotNull("caseCompositionMode is required.", caseCompositionMode);
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(baseCases);
        FuzzyPreconditions.checkNotNull("composition function is required.", composition);
        Subcase[][] composedSubcases = caseCompositionMode.algorithm.apply(baseCases);
        HashSet<Subcase<Object>> subcases = new HashSet<Subcase<Object>>();
        for (Subcase[] subcase : composedSubcases) {
            subcases.add(r -> {
                Object[] values = new Object[subcase.length];
                for (int j = 0; j < subcase.length; ++j) {
                    Subcase supplier = subcase[j];
                    values[j] = supplier.generate(r);
                }
                return composition.apply(r, values);
            });
        }
        return () -> subcases;
    }

    public static <INPUT, OUTPUT> Case<OUTPUT> compose(Case<INPUT> baseCase, BiFunction<Random, INPUT, OUTPUT> compositionFunction) {
        return Cases.compose(CaseCompositionMode.EACH_SUBCASE_AT_LEAST_ONCE, new Case[]{baseCase}, (random, cases) -> compositionFunction.apply((Random)random, (Object)cases[0]));
    }

    public static <INPUT1, INPUT2, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, TwoCaseCompositionFunction<INPUT1, INPUT2, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1]));
    }

    public static <INPUT1, INPUT2, INPUT3, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, ThreeCaseCompositionFunction<INPUT1, INPUT2, INPUT3, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, FourCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, Case<INPUT5> baseCase5, FiveCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4, baseCase5}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3], (Object)values[4]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, Case<INPUT5> baseCase5, Case<INPUT6> baseCase6, SixCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4, baseCase5, baseCase6}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3], (Object)values[4], (Object)values[5]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, Case<INPUT5> baseCase5, Case<INPUT6> baseCase6, Case<INPUT7> baseCase7, SevenCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4, baseCase5, baseCase6, baseCase7}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3], (Object)values[4], (Object)values[5], (Object)values[6]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, Case<INPUT5> baseCase5, Case<INPUT6> baseCase6, Case<INPUT7> baseCase7, Case<INPUT8> baseCase8, EightCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4, baseCase5, baseCase6, baseCase7, baseCase8}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3], (Object)values[4], (Object)values[5], (Object)values[6], (Object)values[7]));
    }

    public static <INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, INPUT9, OUTPUT> Case<OUTPUT> compose(CaseCompositionMode caseCompositionMode, Case<INPUT1> baseCase1, Case<INPUT2> baseCase2, Case<INPUT3> baseCase3, Case<INPUT4> baseCase4, Case<INPUT5> baseCase5, Case<INPUT6> baseCase6, Case<INPUT7> baseCase7, Case<INPUT8> baseCase8, Case<INPUT9> baseCase9, NineCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, INPUT9, OUTPUT> compositionFunction) {
        return Cases.compose(caseCompositionMode, new Case[]{baseCase1, baseCase2, baseCase3, baseCase4, baseCase5, baseCase6, baseCase7, baseCase8, baseCase9}, (random, values) -> compositionFunction.apply((Random)random, (Object)values[0], (Object)values[1], (Object)values[2], (Object)values[3], (Object)values[4], (Object)values[5], (Object)values[6], (Object)values[7], (Object)values[8]));
    }

    @SafeVarargs
    public static <T> Case<T> of(Subcase<T> ... subcases) {
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(subcases);
        Set subcasesSet = FuzzyUtil.setOf(subcases);
        return () -> subcasesSet;
    }

    @SafeVarargs
    public static <T> Case<T> of(Supplier<T> ... subcases) {
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(subcases);
        HashSet<Subcase<Object>> subcasesSet = new HashSet<Subcase<Object>>(subcases.length);
        for (Supplier supplier : subcases) {
            subcasesSet.add(r -> supplier.get());
        }
        return () -> subcasesSet;
    }

    @SafeVarargs
    public static <T> Case<T> of(T ... literalCases) {
        FuzzyPreconditions.checkNotNull(literalCases);
        HashSet<Subcase<Object>> subcases = new HashSet<Subcase<Object>>(literalCases.length);
        for (Object t : literalCases) {
            subcases.add(r -> t);
        }
        return () -> subcases;
    }

    @SafeVarargs
    public static <T> Case<T> ofDelegates(Supplier<Case<T>> ... delegateCases) {
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(delegateCases);
        HashSet subcases = new HashSet();
        for (Supplier<Case<T>> delegate : delegateCases) {
            subcases.addAll(delegate.get().getSubcases());
        }
        return () -> subcases;
    }

    public static <T, U> Case<U> map(Case<T> original, Function<T, U> mapping) {
        FuzzyPreconditions.checkNotNull(original);
        FuzzyPreconditions.checkNotNull(mapping);
        return Cases.map(original, (Random r, T t) -> mapping.apply(t));
    }

    public static <T, U> Case<U> map(Case<T> original, BiFunction<Random, T, U> mapping) {
        FuzzyPreconditions.checkNotNull(original);
        FuzzyPreconditions.checkNotNull(mapping);
        return () -> {
            Set sourceSubcases = original.getSubcases();
            HashSet<Subcase<Object>> mappedSubcases = new HashSet<Subcase<Object>>(sourceSubcases.size());
            for (Subcase source : sourceSubcases) {
                mappedSubcases.add(r -> mapping.apply(r, source.generate(r)));
            }
            return mappedSubcases;
        };
    }

    public static interface NineCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, INPUT9, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5, INPUT5 var6, INPUT6 var7, INPUT7 var8, INPUT8 var9, INPUT9 var10);
    }

    public static interface EightCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, INPUT8, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5, INPUT5 var6, INPUT6 var7, INPUT7 var8, INPUT8 var9);
    }

    public static interface SevenCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, INPUT7, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5, INPUT5 var6, INPUT6 var7, INPUT7 var8);
    }

    public static interface SixCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, INPUT6, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5, INPUT5 var6, INPUT6 var7);
    }

    public static interface FiveCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, INPUT5, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5, INPUT5 var6);
    }

    public static interface FourCaseCompositionFunction<INPUT1, INPUT2, INPUT3, INPUT4, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4, INPUT4 var5);
    }

    public static interface ThreeCaseCompositionFunction<INPUT1, INPUT2, INPUT3, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3, INPUT3 var4);
    }

    public static interface TwoCaseCompositionFunction<INPUT1, INPUT2, OUTPUT> {
        public OUTPUT apply(Random var1, INPUT1 var2, INPUT2 var3);
    }
}

