/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.CaseCompositionMode;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.Generator;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.pairwise.Pairwise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;

public class Context {
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();
    private final Random random = new Random();
    private final CaseCompositionMode caseCompositionMode;
    private final StackTraceElement[] contextInitTrace;
    private boolean locked;
    private StackTraceElement[] lockTrace;
    private Map<Generator, Case[]> previousGenerators;
    private Map<Generator, Case[]> generators = new HashMap<Generator, Case[]>();
    private Stack<Map<Generator, Iteration>> iterations;

    public static void init(CaseCompositionMode caseCompositionMode, long randomSeed) {
        if (CONTEXT.get() != null) {
            throw CONTEXT.get().newReinitializedException();
        }
        Context c = new Context(caseCompositionMode);
        c.random.setSeed(randomSeed);
        CONTEXT.set(c);
    }

    public static boolean next() {
        Context c = CONTEXT.get();
        if (c == null) {
            throw Context.newUninitializedException();
        }
        if (c.iterations == null || c.iterations.size() == 0) {
            return false;
        }
        if (c.iterations.size() > 1) {
            c.previousGenerators = c.generators;
            c.generators = new HashMap<Generator, Case[]>();
            c.locked = false;
            c.iterations.pop();
            return true;
        }
        c.iterations.pop();
        return false;
    }

    public static void cleanUp() {
        CONTEXT.remove();
    }

    public static Map<Generator, Object> valuesForCurrentIteration() {
        Context c = CONTEXT.get();
        if (c == null) {
            throw Context.newUninitializedException();
        }
        HashMap<Generator, Object> res = new HashMap<Generator, Object>();
        if (c.iterations != null && !c.iterations.isEmpty()) {
            for (Map.Entry<Generator, Iteration> variable : c.iterations.peek().entrySet()) {
                Iteration i = variable.getValue();
                if (!i.generated) continue;
                res.put(variable.getKey(), i.getCurrent());
            }
        }
        return res;
    }

    public static String report() {
        StringBuilder sb = new StringBuilder();
        Context.reportTo(sb);
        return sb.toString();
    }

    public static void reportTo(StringBuilder sb) {
        Context c = CONTEXT.get();
        if (c == null || c.iterations == null || c.iterations.isEmpty()) {
            return;
        }
        for (Map.Entry<Generator, Iteration> variable : c.iterations.peek().entrySet()) {
            Iteration i = variable.getValue();
            if (!i.generated) continue;
            sb.append("  ");
            i.describeTo(sb);
            sb.append(" from generator ");
            sb.append(variable.getKey().getName());
            sb.append('\n');
        }
    }

    static Context getUnlocked() {
        Context c = CONTEXT.get();
        if (c == null) {
            throw Context.newUninitializedException();
        }
        if (c.locked) {
            throw c.newAlreadyLockedException();
        }
        return c;
    }

    private Context(CaseCompositionMode caseCompositionMode) {
        this.caseCompositionMode = FuzzyPreconditions.checkNotNull("A case composition mode is required.", caseCompositionMode);
        this.contextInitTrace = Thread.currentThread().getStackTrace();
    }

    <T> void register(Generator<T> generator, Case<?>[] cases) {
        FuzzyPreconditions.checkNotNull(generator);
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(cases);
        if (this.locked) {
            throw this.newAlreadyLockedException();
        }
        if (this.generators.containsKey(generator)) {
            this.throwDuplicateGenerator(generator);
        }
        this.generators.put(generator, cases);
    }

    <T> T currentValue(Generator<T> generator) {
        this.lock();
        Iteration i = this.iterations.peek().get(generator);
        if (i == null) {
            throw this.newUnregisteredGeneratorException(generator);
        }
        Object value = i.get(this.random);
        return (T)value;
    }

    void lock() {
        if (!this.locked) {
            this.locked = true;
            this.lockTrace = Thread.currentThread().getStackTrace();
            if (this.iterations == null) {
                this.generateTestCases();
            } else {
                this.validateConsistency();
            }
        }
    }

    private void validateConsistency() {
        if (this.previousGenerators == null) {
            return;
        }
        for (Generator g : this.generators.keySet()) {
            if (this.previousGenerators.containsKey(g)) continue;
            throw this.newInconsistentGeneratorsException();
        }
        if (this.generators.size() != this.previousGenerators.size()) {
            throw this.newInconsistentGeneratorsException();
        }
    }

    private void generateTestCases() {
        this.iterations = new Stack();
        if (this.generators.isEmpty()) {
            return;
        }
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Map.Entry<Generator, Case[]> generator : this.generators.entrySet()) {
            variables.add(new Variable(generator.getKey(), generator.getValue()));
        }
        if (!variables.isEmpty()) {
            if (this.caseCompositionMode.equals((Object)CaseCompositionMode.PAIRWISE_PERMUTATIONS_OF_SUBCASES)) {
                this.generatePairwiseTestCases(variables);
            } else if (this.caseCompositionMode.equals((Object)CaseCompositionMode.EACH_SUBCASE_AT_LEAST_ONCE)) {
                this.generateEachSubcaseAtLeastOnceCases(variables);
            } else {
                throw new IllegalStateException("Unexpected caseCompositionMode " + (Object)((Object)this.caseCompositionMode));
            }
        }
    }

    private void generatePairwiseTestCases(List<Variable> variables) {
        Pairwise<Variable> permuter = new Pairwise<Variable>(variables);
        Stack<List<Object>> permutations = permuter.generate();
        for (List list : permutations) {
            HashMap<Generator, Iteration> wholeIteration = new HashMap<Generator, Iteration>(variables.size());
            this.iterations.push(wholeIteration);
            for (int i = 0; i < variables.size(); ++i) {
                Subcase supplier = (Subcase)list.get(i);
                Variable sourceVar = variables.get(i);
                Iteration iteration = new Iteration(supplier);
                wholeIteration.put(sourceVar.g, iteration);
            }
        }
    }

    private void generateEachSubcaseAtLeastOnceCases(List<Variable> variables) {
        int maxSubcases = variables.stream().mapToInt(ArrayList::size).max().orElse(0);
        for (int iteration = 0; iteration < maxSubcases; ++iteration) {
            HashMap<Generator, Iteration> wholeIteration = new HashMap<Generator, Iteration>(variables.size());
            this.iterations.push(wholeIteration);
            for (Variable v : variables) {
                Subcase supplier = (Subcase)v.get(iteration % v.size());
                wholeIteration.put(v.g, new Iteration(supplier));
            }
        }
    }

    private static IllegalStateException newUninitializedException() {
        return new IllegalStateException("You initialized a fuzzy Generator when a fuzzy context had not yet been initialized. Verify that your test case is properly configured, and that you are not creating Generators on a thread other than the main thread executing your tests.");
    }

    private IllegalStateException newUnregisteredGeneratorException(Generator<?> generator) {
        StringBuilder message = new StringBuilder();
        message.append("You attempted to read the value of a generator that was not created as part of the current ");
        message.append("test. Perhaps you are using a generator created for a different test?");
        if (generator != null) {
            message.append("\n");
            this.reportGeneratorTo("unregistered", generator, message);
        }
        if (this.generators != null && !this.generators.isEmpty()) {
            message.append("\n");
            message.append("The available generators were:\n\n");
            for (Generator available : this.generators.keySet()) {
                this.reportGeneratorTo("", available, message);
            }
        }
        throw new IllegalStateException(message.toString());
    }

    private IllegalStateException newInconsistentGeneratorsException() {
        StringBuilder message = new StringBuilder();
        message.append("The generators declared for the current iteration of this test are different than those ");
        message.append("declared for the first iteration. This can lead to inconsistent test results and is ");
        message.append("therefore disallowed. Ensure that your generators are being initialized consistently, ");
        message.append("regardless of other state and variables within your test.\n");
        message.append("\n");
        if (this.previousGenerators == null || this.previousGenerators.isEmpty()) {
            message.append("The first test iteration did not declare any generators.\n");
            message.append("\n");
        } else {
            message.append("The first test iteration declared the following generators:\n");
            message.append("\n");
            for (Generator prev : this.previousGenerators.keySet()) {
                this.reportGeneratorTo("", prev, message);
            }
        }
        if (this.generators == null || this.generators.isEmpty()) {
            message.append("The current test iteration did not declare any generators.\n");
        } else {
            message.append("The current test iteration declared the following generators.\n");
            message.append("\n");
            for (Generator curr : this.generators.keySet()) {
                this.reportGeneratorTo("", curr, message);
            }
        }
        return new IllegalStateException(message.toString());
    }

    private IllegalStateException newReinitializedException() {
        StringBuilder message = new StringBuilder();
        message.append("The fuzzy context for this test was incorrectly initialized more than once. This is likely a ");
        message.append("problem with the test framework that you are using.\n");
        message.append("\n");
        message.append("If you are controlling the fuzzy context manually, make sure to invoke Context.cleanUp() ");
        message.append("before you call Context.init(...) a second time. See the documentation for Context for a ");
        message.append("usage example.\n");
        message.append("\n");
        message.append("The context was previously initialized at the following location:\n");
        message.append("\n");
        for (StackTraceElement e : this.contextInitTrace) {
            message.append("  at ").append(e.toString()).append("\n");
        }
        return new IllegalStateException(message.toString());
    }

    private IllegalStateException newAlreadyLockedException() {
        StringBuilder message = new StringBuilder();
        message.append("Cannot modify a test context that has already been locked.\n\n");
        message.append("The most likely cause of this error is that you attempted to declare a new Generator ");
        message.append("after getting the value of another generator in the same test. All generators for a test ");
        message.append("must be declared before calling .get() on any of them.\n\n");
        if (this.lockTrace != null) {
            message.append("The context was locked at the following stack trace:\n");
            for (StackTraceElement e : this.lockTrace) {
                message.append("  at ").append(e.toString()).append("\n");
            }
            message.append("\n");
        }
        return new IllegalStateException(message.toString());
    }

    private void throwDuplicateGenerator(Generator g) {
        StringBuilder sb = new StringBuilder();
        sb.append("Illegal attempt to register the same generator twice within the same test case.");
        sb.append("\n");
        this.reportGeneratorTo("New", g, sb);
        Generator existing = this.generators.keySet().stream().filter(g::equals).findFirst().orElse(null);
        if (existing != null) {
            this.reportGeneratorTo("Existing", existing, sb);
        }
        throw new IllegalStateException(sb.toString());
    }

    private void reportGeneratorTo(String context, Generator g, StringBuilder sb) {
        sb.append("  ");
        sb.append(context);
        sb.append(" generator: ");
        sb.append(g.getName());
        sb.append(", created\n");
        for (StackTraceElement frame : g.getCreationSite()) {
            sb.append("    at ");
            sb.append(((Object)frame).toString());
            sb.append("\n");
        }
        sb.append("\n");
    }

    private static class Iteration {
        private Object iterationValue;
        private volatile boolean generated;
        private final Subcase<?> subcase;

        public Iteration(Subcase<?> subcase) {
            this.subcase = subcase;
        }

        synchronized Object getCurrent() {
            return this.iterationValue;
        }

        synchronized Object get(Random random) {
            if (!this.generated) {
                this.iterationValue = this.subcase.generate(random);
                this.generated = true;
            }
            return this.iterationValue;
        }

        synchronized void describeTo(StringBuilder sb) {
            if (!this.generated) {
                sb.append("{not generated}");
            } else {
                Subcase<?> castSubcase = this.subcase;
                castSubcase.describeTo(sb, this.iterationValue);
            }
        }
    }

    private static class Variable
    extends ArrayList<Subcase<?>> {
        private static final long serialVersionUID = 1L;
        final transient Generator g;

        Variable(Generator g, Case<?>[] cases) {
            this.g = g;
            for (Case<?> c : cases) {
                this.addAll(c.getSubcases());
            }
        }
    }
}

