/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.FuzzyPreconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;

public class FuzzyUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Map<Integer, String> JAVA_ESCAPES;
    private static final int MAX_INSPECT_DEPTH = 3;
    private static final int MAX_COLLECTION_LENGTH = 50;

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... sets) {
        HashSet<T> ret = new HashSet<T>();
        if (sets != null) {
            for (Set<T> set : sets) {
                if (set == null) continue;
                ret.addAll(set);
            }
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptySet();
        }
        HashSet<T> ret = new HashSet<T>(elements.length);
        ret.addAll(Arrays.asList(elements));
        return ret;
    }

    public static Set<String> toCharSet(String chars) {
        if (chars == null || chars.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> ret = new HashSet<String>(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            ret.add(Character.toString(chars.charAt(i)));
        }
        return ret;
    }

    public static String inspect(Object value) {
        StringBuilder sb = new StringBuilder();
        FuzzyUtil.inspectTo(sb, value);
        return sb.toString();
    }

    public static void inspectTo(StringBuilder sb, Object value) {
        FuzzyPreconditions.checkNotNull(sb);
        FuzzyUtil.inspectToInternal(sb, value, 1);
    }

    private static void inspectIterableTo(StringBuilder sb, char open, Iterable i, Consumer<Object> elementAppender, char close) {
        sb.append(open);
        boolean first = true;
        int idx = 0;
        for (Object o : i) {
            if (first) {
                first = false;
            } else {
                if (++idx >= 50) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
            }
            elementAppender.accept(o);
        }
        sb.append(close);
    }

    private static void inspectToInternal(StringBuilder sb, final Object value, int depth) {
        Consumer<Integer> appendHex = i -> sb.append("\\u").append(HEX_DIGITS[i >> 12 & 0xF]).append(HEX_DIGITS[i >> 8 & 0xF]).append(HEX_DIGITS[i >> 4 & 0xF]).append(HEX_DIGITS[i & 0xF]);
        if (value == null) {
            sb.append("{null}");
        } else if (value instanceof CharSequence) {
            sb.append('\"');
            ((CharSequence)value).codePoints().forEachOrdered(i -> {
                if (JAVA_ESCAPES.containsKey(i)) {
                    sb.append(JAVA_ESCAPES.get(i));
                } else if (i > 65535) {
                    char[] pair;
                    for (char c : pair = Character.toChars(i)) {
                        appendHex.accept(Integer.valueOf(c));
                    }
                } else if (i < 32 || i > 127) {
                    appendHex.accept(i);
                } else {
                    sb.append((char)i);
                }
            });
            sb.append('\"');
        } else if (value instanceof Map) {
            if (depth > 3) {
                sb.append("...");
                return;
            }
            FuzzyUtil.inspectIterableTo(sb, '{', ((Map)value).entrySet(), o -> {
                Map.Entry e = (Map.Entry)o;
                FuzzyUtil.inspectToInternal(sb, e.getKey(), depth + 1);
                sb.append(": ");
                FuzzyUtil.inspectToInternal(sb, e.getValue(), depth + 1);
            }, '}');
        } else if (value.getClass().isArray()) {
            if (depth > 3) {
                sb.append("...");
                return;
            }
            FuzzyUtil.inspectIterableTo(sb, '[', () -> new Iterator(){
                int i = 0;
                int len = Array.getLength(value);

                @Override
                public boolean hasNext() {
                    return this.i < this.len;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return Array.get(value, this.i++);
                }
            }, o -> FuzzyUtil.inspectToInternal(sb, o, depth + 1), ']');
        } else if (value instanceof Iterable) {
            if (depth > 3) {
                sb.append("...");
                return;
            }
            FuzzyUtil.inspectIterableTo(sb, '[', (Iterable)value, o -> FuzzyUtil.inspectToInternal(sb, o, depth + 1), ']');
        } else {
            sb.append(value.toString());
        }
    }

    static {
        HashMap<Integer, String> escapes = new HashMap<Integer, String>();
        escapes.put(92, "\\\\");
        escapes.put(8, "\\b");
        escapes.put(10, "\\n");
        escapes.put(9, "\\t");
        escapes.put(12, "\\f");
        escapes.put(13, "\\r");
        escapes.put(34, "\\\"");
        JAVA_ESCAPES = Collections.unmodifiableMap(escapes);
    }
}

