/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy;

import com.redfin.fuzzy.Any;
import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Cases;
import com.redfin.fuzzy.Context;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.Subcase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Generator<T>
implements Comparable<Generator<T>> {
    private final Context context;
    private String name = "Unknown";
    private StackTraceElement[] creationSite = new StackTraceElement[0];

    Generator(Context c) {
        this.context = c;
    }

    public final String getName() {
        return this.name;
    }

    public final List<StackTraceElement> getCreationSite() {
        return Collections.unmodifiableList(Arrays.asList(this.creationSite));
    }

    public final T get() {
        return this.context.currentValue(this);
    }

    public static GeneratorBuilder named(String name) {
        return new GeneratorBuilder(FuzzyPreconditions.checkNotNull(name));
    }

    @SafeVarargs
    public static <X> Generator<X> of(Case<X> ... cases) {
        return new GeneratorBuilder().of(cases);
    }

    @SafeVarargs
    public static <X> Generator<X> of(X ... literals) {
        return new GeneratorBuilder().of(literals);
    }

    @SafeVarargs
    public static <X> Generator<X> ofCases(Case<X> ... cases) {
        return new GeneratorBuilder().of(cases);
    }

    @SafeVarargs
    public static <X> Generator<X> of(Subcase<X> ... subcases) {
        return new GeneratorBuilder().of(subcases);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof Generator && this.name.equals(((Generator)obj).name);
    }

    @Override
    public final int compareTo(Generator<T> o) {
        return this.name.compareTo(o.name);
    }

    static /* synthetic */ StackTraceElement[] access$202(Generator x0, StackTraceElement[] x1) {
        x0.creationSite = x1;
        return x1;
    }

    public static class GeneratorBuilder {
        private final String name;
        private final StackTraceElement[] creationSite;

        private GeneratorBuilder(String name) {
            this.name = name;
            this.creationSite = Thread.currentThread().getStackTrace();
        }

        private GeneratorBuilder() {
            this.creationSite = Thread.currentThread().getStackTrace();
            this.name = "at " + this.creationSite[4].toString();
        }

        @SafeVarargs
        public final <X> Generator<X> of(Case<X> ... cases) {
            FuzzyPreconditions.checkNotNullAndContainsNoNulls(cases);
            FuzzyPreconditions.checkNotEmpty(cases);
            Context c = Context.getUnlocked();
            Generator g = new Generator(c);
            Generator.access$202(g, this.creationSite);
            g.name = this.name;
            c.register(g, cases);
            return g;
        }

        @SafeVarargs
        public final <X> Generator<X> ofCases(Case<X> ... cases) {
            return this.of(cases);
        }

        @SafeVarargs
        public final <X> Generator<X> of(X ... literals) {
            return this.of(Any.of(literals));
        }

        @SafeVarargs
        public final <X> Generator<X> of(Subcase<X> ... subcases) {
            FuzzyPreconditions.checkNotNullAndContainsNoNulls(subcases);
            return this.of(Cases.of(subcases));
        }
    }
}

