/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Subcase;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DoubleNumericCase
implements Case<Double> {
    public static final double MAX_GENERATED = 1.0E308;
    public static final double MIN_GENERATED = -1.0E308;
    public static final double MAX_GENERATED_FRACTIONAL = 0.99999999;
    public static final double MIN_GENERATED_FRACTIONAL = 1.0E-8;
    private static final int MAX_ATTEMPTS = 100;
    private Double min;
    private Double max;
    private final Set<Double> excluding = new HashSet<Double>();

    public Case<Double> inRange(double minInclusive, double maxInclusive) {
        if (maxInclusive <= minInclusive) {
            throw new IllegalArgumentException("minInclusive must be less than maxInclusive.");
        }
        this.min = minInclusive;
        this.max = maxInclusive;
        return this;
    }

    public Case<Double> lessThan(double maxExclusive) {
        this.max = maxExclusive;
        this.min = null;
        this.excluding.add(this.max);
        return this;
    }

    public Case<Double> lessThanOrEqualTo(double maxInclusive) {
        this.max = maxInclusive;
        this.min = null;
        return this;
    }

    public Case<Double> greaterThan(double minExclusive) {
        this.min = minExclusive;
        this.max = null;
        this.excluding.add(this.min);
        return this;
    }

    public Case<Double> greaterThanOrEqualTo(double minInclusive) {
        this.max = null;
        this.min = minInclusive;
        return this;
    }

    public DoubleNumericCase excluding(Iterable<Double> values) {
        if (values != null) {
            for (Double d : values) {
                if (d == null) continue;
                this.excluding.add(d);
            }
        }
        return this;
    }

    private Subcase<Double> exclude(Subcase<Double> subcase) {
        return r -> {
            for (int i = 0; i < 100; ++i) {
                double d = (Double)subcase.generate(r);
                if (this.excluding.contains(d)) continue;
                return d;
            }
            throw new IllegalStateException("DoubleNumericCase could not generate a value that was not marked as excluded.");
        };
    }

    private static Subcase<Double> subcaseInRange(double min, double max) {
        return r -> min + r.nextDouble() * (max - min);
    }

    @Override
    public Set<Subcase<Double>> getSubcases() {
        HashSet<Subcase<Double>> cases = new HashSet<Subcase<Double>>();
        if (!(this.excluding.contains(0.0) || this.min != null && !(this.min < 0.0) || this.max != null && !(this.max > 0.0))) {
            cases.add(r -> 0.0);
        }
        if (this.min == null) {
            cases.add(DoubleNumericCase.subcaseInRange(-1.0E308, -1.0));
        } else if (this.min < -1.0) {
            cases.add(DoubleNumericCase.subcaseInRange(this.min, this.max == null ? -1.0 : Math.min(this.max, -1.0)));
        }
        if ((this.min == null || this.min < 0.0) && (this.max == null || this.max > -1.0)) {
            cases.add(DoubleNumericCase.subcaseInRange(this.min == null ? -0.99999999 : Math.max(this.min, -0.99999999), this.max == null ? -1.0E-8 : Math.min(this.max, -1.0E-8)));
        }
        if (this.max == null) {
            cases.add(DoubleNumericCase.subcaseInRange(1.0, 1.0E308));
        } else if (this.max > 1.0) {
            cases.add(DoubleNumericCase.subcaseInRange(this.min == null ? 1.0 : Math.max(this.min, 1.0), this.max));
        }
        if ((this.min == null || this.min < 1.0) && (this.max == null || this.max > 0.0)) {
            cases.add(DoubleNumericCase.subcaseInRange(this.min == null ? 1.0E-8 : Math.max(this.min, 1.0E-8), this.max == null ? 0.99999999 : Math.min(this.max, 0.99999999)));
        }
        if (this.min != null && !this.excluding.contains(this.min)) {
            cases.add(r -> this.min);
        }
        if (this.max != null && !this.excluding.contains(this.max)) {
            cases.add(r -> this.max);
        }
        return cases.stream().map(this::exclude).collect(Collectors.toSet());
    }
}

