/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.Subcases;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExcludingCase<T>
implements Case<T> {
    private static final int MAX_ATTEMPTS = 100;
    private final Case<T> baseCase;
    private final Set<T> excludedValues = new HashSet<T>();

    public ExcludingCase(Case<T> baseCase, T excludedValue) {
        this(baseCase, (Iterable<T>)Collections.singleton(excludedValue));
    }

    public ExcludingCase(Case<T> baseCase, T ... excludedValues) {
        this(baseCase, (Iterable<T>)(excludedValues == null ? null : Arrays.asList(excludedValues)));
    }

    public ExcludingCase(Case<T> baseCase, Iterable<T> excludedValues) {
        FuzzyPreconditions.checkNotNull(baseCase);
        this.baseCase = baseCase;
        if (excludedValues != null) {
            for (T t : excludedValues) {
                this.excludedValues.add(t);
            }
        }
    }

    @Override
    public Set<Subcase<T>> getSubcases() {
        return Subcases.map(this.baseCase.getSubcases(), subcase -> r -> {
            for (int i = 0; i < 100; ++i) {
                Object t = subcase.generate(r);
                if (this.excludedValues.contains(t)) continue;
                return t;
            }
            throw new IllegalStateException(String.format("Failed to exclude unwanted values from a base case of type %s.", this.baseCase.getClass()));
        });
    }

    @Override
    public ExcludingCase<T> excluding(Iterable<T> values) {
        if (values != null) {
            for (T t : values) {
                this.excludedValues.add(t);
            }
        }
        return this;
    }
}

