/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Any;
import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.Subcases;
import java.util.HashSet;
import java.util.Set;

public class FloatNumericCase
implements Case<Float> {
    public static final float MAX_GENERATED = 1.0E38f;
    public static final float MIN_GENERATED = -1.0E38f;
    private Float min;
    private Float max;
    private final Set<Double> excluding = new HashSet<Double>();

    public Case<Float> inRange(float minInclusive, float maxInclusive) {
        if (maxInclusive <= minInclusive) {
            throw new IllegalArgumentException("minInclusive must be less than maxInclusive.");
        }
        this.min = Float.valueOf(minInclusive);
        this.max = Float.valueOf(maxInclusive);
        return this;
    }

    public Case<Float> lessThan(float maxExclusive) {
        this.max = Float.valueOf(maxExclusive);
        this.min = null;
        this.excluding.add(Double.valueOf(maxExclusive));
        return this;
    }

    public Case<Float> lessThanOrEqualTo(float maxInclusive) {
        this.max = Float.valueOf(maxInclusive);
        this.min = null;
        return this;
    }

    public Case<Float> greaterThan(float minExclusive) {
        this.max = null;
        this.min = Float.valueOf(minExclusive);
        this.excluding.add(Double.valueOf(minExclusive));
        return this;
    }

    public Case<Float> greaterThanOrEqualTo(float minInclusive) {
        this.max = null;
        this.min = Float.valueOf(minInclusive);
        return this;
    }

    @Override
    public Case<Float> excluding(Iterable<Float> values) {
        if (values != null) {
            for (Float f : values) {
                if (f == null) continue;
                this.excluding.add(f.doubleValue());
            }
        }
        return this;
    }

    @Override
    public Set<Subcase<Float>> getSubcases() {
        Case<Double> baseCase = Any.doublePrecisionNumber().inRange(this.min == null ? (double)-1.0E38f : (double)this.min.floatValue(), this.max == null ? (double)1.0E38f : (double)this.max.floatValue()).excluding((Iterable<Double>)this.excluding);
        return Subcases.mapOutput(baseCase.getSubcases(), Double::floatValue);
    }
}

