/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Any;
import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.Generator;
import com.redfin.fuzzy.Literal;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.Subcases;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class NumericCase<T extends Number>
implements Case<T> {
    private static final int MAX_ATTEMPTS = 100;
    private T min;
    private T max;
    private final Set<T> excluded = new HashSet<T>();

    public Case<T> inRange(T minInclusive, T maxInclusive) {
        FuzzyPreconditions.checkNotNull(minInclusive);
        FuzzyPreconditions.checkNotNull(maxInclusive);
        if (this.lt(maxInclusive, minInclusive) || minInclusive.equals(maxInclusive)) {
            throw new IllegalArgumentException("minInclusive must be less than maxInclusive.");
        }
        this.min = minInclusive;
        this.max = maxInclusive;
        return this;
    }

    protected T getMax() {
        return this.max;
    }

    protected T getMin() {
        return this.min;
    }

    public Case<T> lessThanOrEqualTo(T maxInclusive) {
        FuzzyPreconditions.checkNotNull(maxInclusive);
        this.min = null;
        this.max = maxInclusive;
        return this;
    }

    public Case<T> greaterThanOrEqualTo(T minInclusive) {
        FuzzyPreconditions.checkNotNull(minInclusive);
        this.min = minInclusive;
        this.max = null;
        return this;
    }

    @Override
    public Case<T> excluding(Iterable<T> values) {
        if (values != null) {
            for (Number t : values) {
                this.excluded.add(t);
            }
        }
        return this;
    }

    public Case<T> greaterThanOrEqualTo(Generator<T> minInclusive) {
        FuzzyPreconditions.checkNotNull(minInclusive);
        return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)minInclusive.get()), this.newCase().greaterThanOrEqualTo(this.i2t(1)).getSubcases(), (random, base, distance) -> this.add(base, distance));
    }

    public Case<T> lessThanOrEqualTo(Generator<T> maxInclusive) {
        FuzzyPreconditions.checkNotNull(maxInclusive);
        return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)maxInclusive.get()), this.newCase().greaterThanOrEqualTo(this.i2t(1)).getSubcases(), (random, base, distance) -> this.add(base, this.negate(distance)));
    }

    public WithinChain<T> within(T range) {
        FuzzyPreconditions.checkNotNull(range);
        if (this.lt(range, this.i2t(1))) {
            throw new IllegalArgumentException();
        }
        return new WithinChain(this.newCase(), (Number)range, null);
    }

    private Subcase<T> exclude(Subcase<T> subcase) {
        return r -> {
            for (int i = 0; i < 100; ++i) {
                Number t = (Number)subcase.generate(r);
                if (this.excluded.contains(t)) continue;
                return t;
            }
            throw new IllegalStateException("Numeric case could not generate a value that was not marked as excluded.");
        };
    }

    @Override
    public Set<Subcase<T>> getSubcases() {
        T max;
        T d;
        HashSet<Subcase<T>> subcases = new HashSet<Subcase<T>>(3);
        Object zero = this.i2t(0);
        if (this.min != null && this.max != null && this.lt(this.max, zero)) {
            d = this.add(this.max, this.negate(this.min));
            subcases.add(r -> this.add(this.min, this.rngLessThan(r, d)));
        } else if (this.min == null || this.lt(this.min, zero)) {
            if (this.min == null) {
                subcases.add(r -> this.negate(this.abs(this.rng(r))));
            } else {
                max = this.negate(this.min);
                subcases.add(r -> this.negate(this.rngLessThan(r, max)));
            }
        }
        if (this.max != null && this.min != null && this.lt(zero, this.min)) {
            d = this.add(this.max, this.negate(this.min));
            subcases.add(r -> this.add(this.min, this.rngLessThan(r, d)));
        } else if (this.max == null || this.lt(zero, this.max)) {
            if (this.max == null) {
                subcases.add(r -> this.abs(this.rng(r)));
            } else {
                max = this.max;
                subcases.add(r -> this.rngLessThan(r, max));
            }
        }
        if ((this.min == null || this.lt(this.min, zero) || zero.equals(this.min)) && (this.max == null || this.lt(zero, this.max) || zero.equals(this.max)) && !this.excluded.contains(zero)) {
            subcases.add(r -> zero);
        }
        if (this.min != null && !this.min.equals(zero) && !this.excluded.contains(this.min)) {
            subcases.add(r -> this.min);
        }
        if (this.max != null && !this.max.equals(zero) && !this.excluded.contains(this.max)) {
            subcases.add(r -> this.max);
        }
        this.addAdditionalSubcases(subcases);
        return subcases.stream().map(this::exclude).collect(Collectors.toSet());
    }

    protected abstract NumericCase<T> newCase();

    protected abstract T add(T var1, T var2);

    protected abstract T negate(T var1);

    protected abstract T abs(T var1);

    protected abstract T i2t(int var1);

    protected abstract boolean lt(T var1, T var2);

    protected abstract T rng(Random var1);

    protected abstract T rngLessThan(Random var1, T var2);

    protected void addAdditionalSubcases(Set<Subcase<T>> subcases) {
    }

    public static NumericCase<Byte> ofBytes() {
        return new NumericCase<Byte>(){

            @Override
            protected NumericCase<Byte> newCase() {
                return Any.byteInteger();
            }

            @Override
            protected Byte add(Byte a, Byte b) {
                long r = a.longValue() + b.longValue();
                return (byte)(r < -128L ? -128 : (byte)(r > 127L ? 127 : (byte)r));
            }

            @Override
            protected Byte negate(Byte b) {
                return -b.byteValue();
            }

            @Override
            protected Byte abs(Byte b) {
                return b < 0 ? -b.byteValue() : b;
            }

            @Override
            protected Byte i2t(int i) {
                return (byte)i;
            }

            @Override
            protected boolean lt(Byte a, Byte b) {
                return a < b;
            }

            @Override
            protected Byte rng(Random random) {
                byte[] b = new byte[1];
                random.nextBytes(b);
                return b[0] == 0 ? (byte)1 : b[0];
            }

            @Override
            protected Byte rngLessThan(Random random, Byte maxInclusive) {
                return (byte)(1 + random.nextInt(maxInclusive.byteValue()) & 0x7F);
            }
        };
    }

    public static NumericCase<Short> ofShorts() {
        return new NumericCase<Short>(){

            @Override
            protected NumericCase<Short> newCase() {
                return Any.shortInteger();
            }

            @Override
            protected Short add(Short a, Short b) {
                long r = a.longValue() + b.longValue();
                return (short)(r < -32768L ? Short.MIN_VALUE : (short)(r > 32767L ? Short.MAX_VALUE : (short)r));
            }

            @Override
            protected Short negate(Short s) {
                return -s.shortValue();
            }

            @Override
            protected Short abs(Short s) {
                return s < 0 ? -s.shortValue() : s;
            }

            @Override
            protected Short i2t(int i) {
                return (short)i;
            }

            @Override
            protected boolean lt(Short a, Short b) {
                return a < b;
            }

            @Override
            protected Short rng(Random random) {
                byte[] b = new byte[2];
                random.nextBytes(b);
                short s = (short)(b[0] << 8 & b[1]);
                return s == 0 ? (short)1 : s;
            }

            @Override
            protected Short rngLessThan(Random random, Short maxInclusive) {
                return (short)(1 + random.nextInt(maxInclusive.shortValue()) & Short.MAX_VALUE);
            }
        };
    }

    public static NumericCase<Integer> ofIntegers() {
        return new NumericCase<Integer>(){

            @Override
            protected NumericCase<Integer> newCase() {
                return Any.integer();
            }

            @Override
            protected Integer add(Integer a, Integer b) {
                long r = a.longValue() + b.longValue();
                return r < Integer.MIN_VALUE ? Integer.MIN_VALUE : (r > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)r);
            }

            @Override
            protected Integer negate(Integer integer) {
                return -integer.intValue();
            }

            @Override
            protected Integer abs(Integer integer) {
                int i = integer;
                return i < 0 ? -i : i;
            }

            @Override
            protected Integer i2t(int i) {
                return i;
            }

            @Override
            protected boolean lt(Integer a, Integer b) {
                return a < b;
            }

            @Override
            protected Integer rng(Random random) {
                int i = random.nextInt();
                return i == 0 ? 1 : i;
            }

            @Override
            protected Integer rngLessThan(Random random, Integer maxInclusive) {
                return 1 + random.nextInt(maxInclusive);
            }
        };
    }

    public static NumericCase<Long> ofLongs() {
        return new NumericCase<Long>(){

            @Override
            protected NumericCase<Long> newCase() {
                return Any.longInteger();
            }

            @Override
            protected Long add(Long a, Long b) {
                return a + b;
            }

            @Override
            protected Long negate(Long lng) {
                return -lng.longValue();
            }

            @Override
            protected Long abs(Long lng) {
                long l = lng;
                return l < 0L ? -l : l;
            }

            @Override
            protected Long i2t(int i) {
                return i;
            }

            @Override
            protected boolean lt(Long a, Long b) {
                return a < b;
            }

            @Override
            protected Long rng(Random random) {
                long l = random.nextLong();
                return l == 0L ? 1L : l;
            }

            @Override
            protected Long rngLessThan(Random random, Long maxInclusive) {
                if (maxInclusive > Integer.MAX_VALUE) {
                    long l;
                    for (l = random.nextLong() & Long.MAX_VALUE; l >= maxInclusive; l >>= 1) {
                    }
                    return l;
                }
                return 1L + (long)random.nextInt(maxInclusive.intValue());
            }

            @Override
            protected void addAdditionalSubcases(Set<Subcase<Long>> subcases) {
                if ((this.getMax() == null || (Long)this.getMax() > Integer.MIN_VALUE) && this.getMin() == null) {
                    subcases.add(r -> Integer.MIN_VALUE - (1L + ((long)r.nextInt() & 0x3FFFFFFFL)));
                }
                if ((this.getMin() == null || (Long)this.getMin() < Integer.MAX_VALUE) && this.getMax() == null) {
                    subcases.add(r -> 0x80000000L + ((long)r.nextInt() & 0x3FFFFFFFL));
                }
            }
        };
    }

    public static class WithinChain<T extends Number> {
        private final NumericCase<T> baseCase;
        private final T range;

        private WithinChain(NumericCase<T> baseCase, T range) {
            this.baseCase = baseCase;
            this.range = range;
        }

        public Case<T> butExcludingValueOf(Generator<T> number) {
            FuzzyPreconditions.checkNotNull(number);
            if (this.range.equals(this.baseCase.i2t(1))) {
                return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)number.get()), Any.of(-1, 1).getSubcases(), (random, base, distance) -> this.baseCase.add((Number)base, (Number)this.baseCase.i2t((int)distance)));
            }
            return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)number.get()), Any.of(this.baseCase.newCase().inRange(this.baseCase.negate(this.range), this.baseCase.i2t(-1)), this.baseCase.newCase().inRange(this.baseCase.i2t(1), this.range)).getSubcases(), (random, base, distance) -> this.baseCase.add((Number)base, (Number)distance));
        }

        public Case<T> of(Generator<T> number) {
            FuzzyPreconditions.checkNotNull(number);
            if (this.range.equals(this.baseCase.i2t(1))) {
                return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)number.get()), Any.of(-1, 0, 1).getSubcases(), (random, base, distance) -> this.baseCase.add((Number)base, (Number)this.baseCase.i2t((int)distance)));
            }
            return () -> Subcases.pairwisePermutations(Collections.singleton(random -> (Number)number.get()), Any.of(this.baseCase.newCase().inRange(this.baseCase.negate(this.range), this.baseCase.i2t(-1)), Literal.value(this.baseCase.i2t(0)), this.baseCase.newCase().inRange(this.baseCase.i2t(1), this.range)).getSubcases(), (random, base, distance) -> this.baseCase.add((Number)base, (Number)distance));
        }

        /* synthetic */ WithinChain(NumericCase x0, Number x1, 1 x2) {
            this(x0, x1);
        }
    }
}

