/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Any;
import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Cases;
import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.FuzzyUtil;
import com.redfin.fuzzy.Literal;
import com.redfin.fuzzy.Subcase;
import com.redfin.fuzzy.Subcases;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StringCase
implements Case<String> {
    static final Set<String> ALPHABET_CHARS = Collections.unmodifiableSet(FuzzyUtil.toCharSet("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    static final Set<String> DIGIT_CHARS = Collections.unmodifiableSet(FuzzyUtil.toCharSet("0123456789"));
    static final Set<String> HEX_CHARS = Collections.unmodifiableSet(FuzzyUtil.toCharSet("0123456789abcdef"));
    static final Set<String> UNICODE_CHARS = Collections.unmodifiableSet(FuzzyUtil.toCharSet("\u30a2\u3042\u8a9e\u0394\u13a3\u2030\u2708"));
    static final Set<String> EMOJI_CHARS = Collections.unmodifiableSet(FuzzyUtil.setOf("\ud83c\udf35", "\ud83c\udf54", "\ud83d\udc17"));
    static final Set<String> WHITESPACE_CHARS = Collections.unmodifiableSet(FuzzyUtil.toCharSet(" \t\r\n\f"));
    static final Set<String> INJECTION_STRINGS = Collections.unmodifiableSet(Collections.singleton("--'\",$%\\<&"));
    private static final Set<String> STANDARD_CHARS = Collections.unmodifiableSet(FuzzyUtil.union(ALPHABET_CHARS, DIGIT_CHARS, WHITESPACE_CHARS, FuzzyUtil.toCharSet("~!@#$%^&*()_+`-=[]\\{}|;':\",./<>?")));
    private Case<Integer> length = Any.of(Literal.value(0), Any.integer().inRange(1, 256));
    private Case<Set<String>> sourceStrings = Any.of(Literal.value(STANDARD_CHARS), Literal.value(WHITESPACE_CHARS), Literal.value(UNICODE_CHARS), Literal.value(EMOJI_CHARS), Literal.value(INJECTION_STRINGS));

    public StringCase withLengthOf(Case<Integer> length) {
        this.length = FuzzyPreconditions.checkNotNull(length);
        return this;
    }

    public StringCase withLength(int length) {
        return this.withLengthOf(Literal.value(length));
    }

    public StringCase nonEmpty() {
        return this.withLengthOf(Any.integer().inRange(1, 256));
    }

    public StringCase withSourceStringsOf(Case<Set<String>> sourceChars) {
        this.sourceStrings = FuzzyPreconditions.checkNotNull(sourceChars);
        return this;
    }

    public StringCase withSourceStrings(Set<String> sourceStrings) {
        return this.withSourceStringsOf(Literal.value(sourceStrings));
    }

    public StringCase withSourceStrings(String ... sourceStrings) {
        FuzzyPreconditions.checkNotNullAndContainsNoNulls(sourceStrings);
        HashSet<String> sourceStringSet = new HashSet<String>(sourceStrings.length);
        sourceStringSet.addAll(Arrays.asList(sourceStrings));
        return this.withSourceStrings(sourceStringSet);
    }

    public StringCase withSourceCharsOf(Case<String> sourceChars) {
        return this.withSourceStringsOf(Cases.map(sourceChars, FuzzyUtil::toCharSet));
    }

    public StringCase withSourceChars(String sourceChars) {
        FuzzyPreconditions.checkNotNull(sourceChars);
        return this.withSourceStrings(FuzzyUtil.toCharSet(sourceChars));
    }

    public StringCase withOnlyAlphabetChars() {
        return this.withSourceStrings(ALPHABET_CHARS);
    }

    public StringCase withOnlyDigitChars() {
        return this.withSourceStrings(DIGIT_CHARS);
    }

    public StringCase withOnlyAlphanumericChars() {
        return this.withSourceStrings(FuzzyUtil.union(ALPHABET_CHARS, DIGIT_CHARS));
    }

    public StringCase withOnlyHexChars() {
        return this.withSourceStrings(HEX_CHARS);
    }

    @Override
    public Set<Subcase<String>> getSubcases() {
        return Subcases.pairwisePermutations(this.length.getSubcases(), this.sourceStrings.getSubcases(), (rnd, length, strings) -> {
            if (length == null || length <= 0) {
                return "";
            }
            if (length > 1024) {
                length = 1024;
            }
            if (strings == null || strings.isEmpty()) {
                strings = Collections.singleton("X");
            }
            String[] stringsArr = strings.toArray(new String[strings.size()]);
            StringBuilder sb = new StringBuilder((int)length);
            while (sb.length() < length) {
                String chr = stringsArr[rnd.nextInt(stringsArr.length)];
                if (chr.length() == 0) {
                    chr = "X";
                }
                sb.append(chr);
                if (sb.length() <= length) continue;
                sb.delete((int)length, sb.length());
            }
            return sb.toString();
        });
    }
}

