/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.cases;

import com.redfin.fuzzy.Case;
import com.redfin.fuzzy.Subcase;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class UnionCase<T>
implements Case<T> {
    private final Set<Case<T>> _subcases;

    @SafeVarargs
    public UnionCase(Case<T> ... subcases) {
        this._subcases = Collections.unmodifiableSet(new HashSet<Case<T>>(Arrays.asList(subcases)));
    }

    @Override
    public Set<Subcase<T>> getSubcases() {
        HashSet<Subcase<T>> subcases = new HashSet<Subcase<T>>(this._subcases.size());
        for (Case<T> subcase : this._subcases) {
            subcases.addAll(subcase.getSubcases());
        }
        return subcases;
    }
}

