/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.pairwise;

import com.redfin.fuzzy.pairwise.Pair;
import com.redfin.fuzzy.pairwise.Param;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class PairSet {
    private final Map<Param, ParamPairs> allPairs = new HashMap<Param, ParamPairs>();
    private int pairs;

    PairSet() {
    }

    void register(Pair pair) {
        this.register(pair.p1.param, pair.p2.param, pair);
        this.register(pair.p2.param, pair.p1.param, pair);
        ++this.pairs;
    }

    boolean isEmpty() {
        return this.pairs <= 0;
    }

    int size() {
        return this.pairs;
    }

    Set<Pair> toSet() {
        HashSet<Pair> set = new HashSet<Pair>(this.pairs);
        for (ParamPairs paramPairs : this.allPairs.values()) {
            for (Pairs subset : paramPairs.pairs.values()) {
                set.addAll(subset);
            }
        }
        return set;
    }

    Pair consume(Param p1, Param p2) {
        Pair p = this.allPairs.get(p1).get(p2).consume();
        if (p == null) {
            return null;
        }
        this.allPairs.get(p2).discard(p);
        --this.pairs;
        return p;
    }

    private void register(Param p1, Param p2, Pair p) {
        if (!this.allPairs.containsKey(p1)) {
            this.allPairs.put(p1, new ParamPairs());
        }
        this.allPairs.get(p1).register(p2, p);
    }

    private static class Pairs
    extends LinkedHashSet<Pair> {
        private static final long serialVersionUID = 1L;

        private Pairs() {
        }

        Pair consume() {
            if (this.size() == 0) {
                return null;
            }
            Iterator i = this.iterator();
            Pair p = (Pair)i.next();
            this.remove(p);
            return p;
        }
    }

    private static class ParamPairs {
        final Map<Param, Pairs> pairs = new HashMap<Param, Pairs>();

        private ParamPairs() {
        }

        Pairs get(Param p2) {
            return this.pairs.get(p2);
        }

        void register(Param p2, Pair p) {
            if (!this.pairs.containsKey(p2)) {
                this.pairs.put(p2, new Pairs());
            }
            this.pairs.get(p2).add(p);
        }

        void discard(Pair p) {
            Pairs subset = this.pairs.get(p.p2.param);
            if (subset != null) {
                subset.remove(p);
            }
        }
    }
}

