/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.fuzzy.pairwise;

import com.redfin.fuzzy.FuzzyPreconditions;
import com.redfin.fuzzy.pairwise.Pair;
import com.redfin.fuzzy.pairwise.PairSet;
import com.redfin.fuzzy.pairwise.Param;
import com.redfin.fuzzy.pairwise.ParamValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class Pairwise<S extends Collection> {
    private final List<Param> params;

    public Pairwise(List<S> parameters) {
        FuzzyPreconditions.checkNotNull(parameters);
        ArrayList<Param> params = new ArrayList<Param>();
        int i = 0;
        for (Collection parameter : parameters) {
            FuzzyPreconditions.checkNotNullAndContainsNoNulls(parameter);
            params.add(new Param(i++, new ArrayList<Object>(parameter)));
        }
        this.params = Collections.unmodifiableList(params);
    }

    PairSet generatePairs() {
        PairSet pairs = new PairSet();
        for (int i = 0; i < this.params.size() - 1; ++i) {
            for (ParamValue p1 : this.params.get((int)i).values) {
                for (int j = i + 1; j < this.params.size(); ++j) {
                    for (ParamValue p2 : this.params.get((int)j).values) {
                        pairs.register(new Pair(p1, p2));
                    }
                }
            }
        }
        return pairs;
    }

    public Stack<List<Object>> generate() {
        if (this.params.size() == 1) {
            Stack<List<Object>> ret = new Stack<List<Object>>();
            for (ParamValue value : this.params.get((int)0).values) {
                ret.push(Collections.singletonList(value.value));
            }
            return ret;
        }
        HashMap<Param, Selector> selectors = new HashMap<Param, Selector>(this.params.size());
        for (Param p : this.params) {
            selectors.put(p, new Selector(p));
        }
        PairSet pairs = this.generatePairs();
        Stack<List<Object>> testCases = new Stack<List<Object>>();
        while (!pairs.isEmpty()) {
            HashMap<Param, Object> chosenValues = new HashMap<Param, Object>(this.params.size());
            for (int i = 0; i < this.params.size() - 1; ++i) {
                for (int j = i + 1; j < this.params.size(); ++j) {
                    Pair p;
                    Param p1 = this.params.get(i);
                    Param p2 = this.params.get(j);
                    if (chosenValues.containsKey(p1) || chosenValues.containsKey(p2) || (p = pairs.consume(p1, p2)) == null) continue;
                    chosenValues.put(p.p1.param, p.p1.value);
                    chosenValues.put(p.p2.param, p.p2.value);
                }
            }
            ArrayList<Object> values = new ArrayList<Object>(this.params.size());
            for (Param p : this.params) {
                if (chosenValues.containsKey(p)) {
                    values.add(chosenValues.get(p));
                    continue;
                }
                values.add(((Selector)selectors.get(p)).next());
            }
            testCases.add(values);
        }
        return testCases;
    }

    private static class Selector {
        private final Param p;
        private int i;

        Selector(Param p) {
            this.p = p;
        }

        Object next() {
            if (this.i >= this.p.values.size()) {
                this.i = 0;
            }
            return this.p.values.get((int)this.i++).value;
        }
    }
}

