/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.alizer.api.spi.framework.nodejs;

import com.redhat.devtools.alizer.api.spi.framework.FrameworkDetectorWithConfigFileProvider;
import com.redhat.devtools.alizer.api.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class NodeJsFrameworkDetectorProvider
implements FrameworkDetectorWithConfigFileProvider {
    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList("JAVASCRIPT", "TYPESCRIPT");
    }

    protected abstract String getFrameworkTag();

    @Override
    public boolean hasFramework(File file) throws IOException {
        return this.getDependenciesFromPackageJson(file).keySet().stream().anyMatch(dependency -> dependency.equals(this.getFrameworkTag()));
    }

    private Map<?, ?> getDependenciesFromPackageJson(File file) throws IOException {
        Map packageJsonContent = Utils.getJsonFileAsMap(file);
        if (!packageJsonContent.containsKey("dependencies")) {
            return Collections.emptyMap();
        }
        return (Map)packageJsonContent.get("dependencies");
    }
}

