/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.toolwindowspane;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JPopupMenuFixture;
import com.intellij.remoterobot.fixtures.JTreeFixture;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="ToolWindowsPane type", xpath="//div[@accessiblename='Project Tool Window']")
@FixtureName(name="Tool Windows Pane")
public class ProjectExplorer
extends CommonContainerFixture {
    private static final String HEAVY_WEIGHT_WINDOW_X_PATH = "//div[@class='HeavyWeightWindow']";
    private RemoteRobot remoteRobot;

    public ProjectExplorer(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public boolean isItemPresent(String ... path) {
        try {
            this.projectViewTree().expand(path);
            this.projectViewTree().clickPath(path, true);
        }
        catch (Exception e) {
            if (!(e instanceof JTreeFixture.PathNotFoundException)) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public void openFile(String ... path) {
        this.projectViewTree().expand(path);
        this.projectViewTree().doubleClickPath(path, true);
    }

    public JPopupMenuFixture openContextMenuOn(String ... path) {
        this.projectViewTree().expand(path);
        this.projectViewTree().rightClickPath(path, true);
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)HEAVY_WEIGHT_WINDOW_X_PATH), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException("The context menu for a file in Project Explorer has not been found.");
        }
    }

    public JPopupMenuFixture openViewsPopup() {
        this.actionButton(Locators.byXpath((String)"//div[@class='ContentComboLabel']"), Duration.ofSeconds(2L)).click();
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)HEAVY_WEIGHT_WINDOW_X_PATH), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException(e.getMessage());
        }
    }

    public void selectOpenedFile() {
        this.actionButton(Locators.byXpath((String)"//div[@myicon='locate.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void expandAll() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='expandall.svg']"), Duration.ofSeconds(2L)).click();
    }

    public void collapseAll() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='collapseall.svg']"), Duration.ofSeconds(2L)).click();
    }

    public JPopupMenuFixture openSettingsPopup() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@myicon='gearPlain.svg']"), Duration.ofSeconds(2L)).click();
        try {
            return (JPopupMenuFixture)this.remoteRobot.find(JPopupMenuFixture.class, Locators.byXpath((String)HEAVY_WEIGHT_WINDOW_X_PATH), Duration.ofSeconds(10L));
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException(e.getMessage());
        }
    }

    public void hide() {
        this.actionButton(Locators.byXpath((String)"//div[contains(@myvisibleactions, 'View),')]//div[@tooltiptext='Hide']"), Duration.ofSeconds(2L)).click();
    }

    public JTreeFixture projectViewTree() {
        return (JTreeFixture)this.find(JTreeFixture.class, JTreeFixture.Companion.byType(), Duration.ofSeconds(10L));
    }
}

