/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.navigation;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.fixtures.JListFixture;
import com.intellij.remoterobot.fixtures.JTextFieldFixture;
import com.intellij.remoterobot.fixtures.dataExtractor.RemoteText;
import com.intellij.remoterobot.search.locators.Locators;
import com.intellij.remoterobot.utils.Keyboard;
import com.intellij.remoterobot.utils.RepeatUtilsKt;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.exceptions.UITestException;
import com.redhat.devtools.intellij.commonuitest.utils.constans.XPathDefinitions;
import com.redhat.devtools.intellij.commonuitest.utils.texttranformation.TextUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="SearchEverywhereUI type", xpath="//div[@accessiblename='Search everywhere' and @class='SearchEverywhereUI']")
@FixtureName(name="Search Everywhere Popup")
public class SearchEverywherePopup
extends CommonContainerFixture {
    private final RemoteRobot remoteRobot;

    public SearchEverywherePopup(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public void activateTab(String tabName) {
        try {
            this.button(Locators.byXpath((String)XPathDefinitions.label(tabName)), Duration.ofSeconds(2L)).click();
        }
        catch (WaitForConditionTimeoutException e) {
            throw new UITestException("The '" + tabName + "' tab cannot be found.");
        }
    }

    public void invokeCmd(String cmdToEnter) {
        JTextFieldFixture searchField = this.textField(JTextFieldFixture.Companion.byType(), Duration.ofSeconds(10L));
        searchField.click();
        searchField.setText(cmdToEnter);
        RepeatUtilsKt.waitFor((Duration)Duration.ofSeconds(30L), (Duration)Duration.ofSeconds(1L), (String)"The search in the Search Everywhere popup did not finish in 30 seconds.", () -> this.didSearchFinish(cmdToEnter));
        new Keyboard(this.remoteRobot).hotKey(new int[]{10});
    }

    private boolean didSearchFinish(String cmdToInvoke) {
        String searchResultsString = TextUtils.listOfRemoteTextToString(this.getSearchResults());
        return searchResultsString.toLowerCase().contains(cmdToInvoke.toLowerCase());
    }

    private List<RemoteText> getSearchResults() {
        List searchResults = this.jLists(JListFixture.Companion.byType());
        if (searchResults.isEmpty()) {
            return new ArrayList<RemoteText>();
        }
        JListFixture searchResultsList = (JListFixture)searchResults.get(0);
        return searchResultsList.findAllText();
    }
}

