/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow;

import com.intellij.remoterobot.RemoteRobot;
import com.intellij.remoterobot.data.RemoteComponent;
import com.intellij.remoterobot.fixtures.CommonContainerFixture;
import com.intellij.remoterobot.fixtures.DefaultXpath;
import com.intellij.remoterobot.fixtures.FixtureName;
import com.intellij.remoterobot.utils.Keyboard;
import com.intellij.remoterobot.utils.WaitForConditionTimeoutException;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.FlatWelcomeFrame;
import com.redhat.devtools.intellij.commonuitest.fixtures.dialogs.navigation.SearchEverywherePopup;
import com.redhat.devtools.intellij.commonuitest.fixtures.mainidewindow.menubar.MenuBar;
import com.redhat.devtools.intellij.commonuitest.utils.internalerror.IdeInternalErrorUtils;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

@DefaultXpath(by="IdeFrameImpl type", xpath="//div[@class='IdeFrameImpl']")
@FixtureName(name="Main IDE Window")
public class MainIdeWindow
extends CommonContainerFixture {
    private final RemoteRobot remoteRobot;

    public MainIdeWindow(@NotNull RemoteRobot remoteRobot, @NotNull RemoteComponent remoteComponent) {
        super(remoteRobot, remoteComponent);
        this.remoteRobot = remoteRobot;
    }

    public void maximizeIdeWindow() {
        if (this.remoteRobot.isWin()) {
            this.runJs("const width = component.getWidth();\nconst height = component.getHeight();\nconst horizontal_offset = width-72;\nrobot.click(component, new Point(horizontal_offset, 14), MouseButton.LEFT_BUTTON, 1);\nconst width_after = component.getWidth();\nconst height_after = component.getHeight();\nconst horizontal_offset_after = width_after-72;\nif (width > width_after || height > height_after) { robot.click(component, new Point(horizontal_offset_after, 14), MouseButton.LEFT_BUTTON, 1); }");
        } else {
            this.runJs("const width = component.getWidth();\nconst height = component.getHeight();\nconst horizontal_offset = width/2;\nrobot.click(component, new Point(horizontal_offset, 10), MouseButton.LEFT_BUTTON, 2);\nconst width_after = component.getWidth();\nconst height_after = component.getHeight();\nconst horizontal_offset_after = width_after/2;\nif (width > width_after || height > height_after) { robot.click(component, new Point(horizontal_offset_after, 10), MouseButton.LEFT_BUTTON, 2); }");
        }
    }

    public void closeProject() {
        if (this.remoteRobot.isWin()) {
            new MenuBar(this.remoteRobot).navigateTo("File", "Close Project");
        } else {
            this.invokeCmdUsingSearchEverywherePopup("Close Project");
        }
        IdeInternalErrorUtils.clearWindowsErrorsIfTheyAppear(this.remoteRobot);
        ((FlatWelcomeFrame)this.remoteRobot.find(FlatWelcomeFrame.class, Duration.ofSeconds(10L))).runJs("const horizontal_offset = component.getWidth()/2;\nrobot.click(component, new Point(horizontal_offset, 10), MouseButton.LEFT_BUTTON, 1);");
    }

    public void invokeCmdUsingSearchEverywherePopup(String cmdToInvoke) {
        SearchEverywherePopup searchEverywherePopup = this.openSearchEverywherePopup("All");
        searchEverywherePopup.invokeCmd(cmdToInvoke);
    }

    private SearchEverywherePopup openSearchEverywherePopup(String tab) {
        try {
            SearchEverywherePopup searchEverywherePopup = (SearchEverywherePopup)this.find(SearchEverywherePopup.class, Duration.ofSeconds(10L));
            searchEverywherePopup.activateTab(tab);
            return searchEverywherePopup;
        }
        catch (WaitForConditionTimeoutException e) {
            Keyboard keyboard = new Keyboard(this.remoteRobot);
            if (this.remoteRobot.isMac()) {
                keyboard.hotKey(new int[]{157, 79});
            } else {
                keyboard.hotKey(new int[]{17, 78});
            }
            SearchEverywherePopup searchEverywherePopup = (SearchEverywherePopup)this.find(SearchEverywherePopup.class, Duration.ofSeconds(10L));
            searchEverywherePopup.activateTab(tab);
            return searchEverywherePopup;
        }
    }
}

