/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;

public class HighSensitivityRegistrar {
    private static final String HIGH = "HIGH";
    private static final String QUALIFIED_CLASSNAME = "com.sun.nio.file.SensitivityWatchEventModifier";

    public boolean isRequired() {
        return this.isMac();
    }

    protected boolean isMac() {
        return SystemInfo.isMac;
    }

    public boolean exists() {
        return this.get() != null;
    }

    public WatchEvent.Modifier get() {
        try {
            Class<WatchEvent.Modifier> sensitivityClass = this.getSensitivityWatchEventModifierClass();
            return this.getEnumConstant(HIGH, sensitivityClass.getEnumConstants());
        }
        catch (ClassNotFoundException | SecurityException e) {
            return null;
        }
    }

    public void registerService(Path path, WatchEvent.Kind<Path>[] kinds, WatchService service) throws IOException {
        if (this.isRequired() && this.exists()) {
            path.register(service, kinds, this.get());
        } else {
            path.register(service, kinds);
        }
    }

    protected Class<WatchEvent.Modifier> getSensitivityWatchEventModifierClass() throws ClassNotFoundException {
        return Class.forName(QUALIFIED_CLASSNAME);
    }

    private WatchEvent.Modifier getEnumConstant(String name, WatchEvent.Modifier[] modifiers) {
        for (WatchEvent.Modifier modifier : modifiers) {
            if (!name.equals(modifier.name())) continue;
            return modifier;
        }
        return null;
    }
}

