/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.actions.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import com.redhat.devtools.intellij.common.CommonConstants;
import com.redhat.devtools.intellij.common.actions.editor.ActionTest;
import com.redhat.devtools.intellij.common.actions.editor.RestoreYAMLClutterActionHandler;
import com.redhat.devtools.intellij.common.utils.YAMLHelper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class RestoreYAMLClutterActionHandlerTest
extends ActionTest {
    private static final String RESOURCE_PATH = "actions/restoreYAMLClutterActionHandler/";

    @Test
    public void ExecuteWriteAction_FileIsTekton_EditorTextIsUpdated() {
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = (RestoreYAMLClutterActionHandler)Mockito.mock(RestoreYAMLClutterActionHandler.class, InvocationOnMock::callRealMethod);
        LightVirtualFile vf = new LightVirtualFile("name", (CharSequence)"content");
        vf.putUserData(CommonConstants.CONTENT, (Object)"content");
        FileDocumentManager fileDocumentManager = (FileDocumentManager)Mockito.mock(FileDocumentManager.class);
        Mockito.when((Object)fileDocumentManager.getFile((Document)ArgumentMatchers.any())).thenReturn((Object)vf);
        try (MockedStatic fileDocumentManagerMockedStatic = Mockito.mockStatic(FileDocumentManager.class);){
            Mockito.when((Object)restoreYAMLClutterActionHandler.getUpdatedContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)"content");
            fileDocumentManagerMockedStatic.when(FileDocumentManager::getInstance).thenReturn((Object)fileDocumentManager);
            restoreYAMLClutterActionHandler.executeWriteAction(this.editor, null, this.dataContext);
            ((Document)Mockito.verify((Object)this.document, (VerificationMode)Mockito.times((int)1))).setText((CharSequence)ArgumentMatchers.anyString());
        }
    }

    @Test
    public void ExecuteWriteAction_FileIsNotTekton_EditorTextIsNotUpdated() {
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = new RestoreYAMLClutterActionHandler();
        LightVirtualFile vf = new LightVirtualFile("name", (CharSequence)"content");
        FileDocumentManager fileDocumentManager = (FileDocumentManager)Mockito.mock(FileDocumentManager.class);
        Mockito.when((Object)fileDocumentManager.getFile((Document)ArgumentMatchers.any())).thenReturn((Object)vf);
        try (MockedStatic fileDocumentManagerMockedStatic = Mockito.mockStatic(FileDocumentManager.class);){
            fileDocumentManagerMockedStatic.when(FileDocumentManager::getInstance).thenReturn((Object)fileDocumentManager);
            restoreYAMLClutterActionHandler.executeWriteAction(this.editor, null, this.dataContext);
            ((Document)Mockito.verify((Object)this.document, (VerificationMode)Mockito.times((int)0))).setText((CharSequence)ArgumentMatchers.anyString());
        }
    }

    @Test
    public void GetUpdatedContent_OriginalContentIsEmpty_CurrentContent() {
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = new RestoreYAMLClutterActionHandler();
        String result = restoreYAMLClutterActionHandler.getUpdatedContent("", "content");
        Assert.assertEquals((Object)"content", (Object)result);
    }

    @Test
    public void GetUpdatedContent_CurrentContentHasNoMetadata_CurrentContentWithOriginalMetadata() throws IOException {
        String content_with_clutters = this.load("actions/restoreYAMLClutterActionHandler/pipeline_with_clutters.yaml");
        String content_without_metadata = this.load("actions/restoreYAMLClutterActionHandler/pipeline_without_metadata.yaml");
        String content_without_metadata_with_merged_metadata = this.load("actions/restoreYAMLClutterActionHandler/pipeline_without_metadata_with_merged_metadata.yaml");
        JsonNode content_without_metadata_with_merged_metadata_Node = YAMLHelper.YAMLToJsonNode((String)content_without_metadata_with_merged_metadata);
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = new RestoreYAMLClutterActionHandler();
        String result = restoreYAMLClutterActionHandler.getUpdatedContent(content_with_clutters, content_without_metadata);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_without_metadata_with_merged_metadata_Node.get("metadata"), (Object)result_Node.get("metadata"));
        Assert.assertEquals((Object)content_without_metadata_with_merged_metadata_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void GetUpdatedContent_CurrentContentHasMetadata_CurrentContentWithMetadataMergedWithOriginalMetadata() throws IOException {
        String content_with_clutters = this.load("actions/restoreYAMLClutterActionHandler/pipeline_with_clutters.yaml");
        String content_with_no_clutters = this.load("actions/restoreYAMLClutterActionHandler/pipeline_with_no_clutters.yaml");
        JsonNode content_with_no_clutters_Node = YAMLHelper.YAMLToJsonNode((String)content_with_no_clutters);
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = new RestoreYAMLClutterActionHandler();
        String result = restoreYAMLClutterActionHandler.getUpdatedContent(content_with_clutters, content_with_no_clutters);
        JsonNode result_Node = YAMLHelper.YAMLToJsonNode((String)result);
        Assert.assertEquals((Object)content_with_no_clutters_Node.get("metadata").get("name"), (Object)result_Node.get("metadata").get("name"));
        Assert.assertFalse((boolean)content_with_no_clutters_Node.get("metadata").has("uid"));
        Assert.assertTrue((boolean)result_Node.get("metadata").has("uid"));
        Assert.assertFalse((boolean)content_with_no_clutters_Node.get("metadata").has("resourceVersion"));
        Assert.assertTrue((boolean)result_Node.get("metadata").has("resourceVersion"));
        Assert.assertEquals((Object)content_with_no_clutters_Node.get("spec"), (Object)result_Node.get("spec"));
    }

    @Test
    public void IsCleaned_False() {
        RestoreYAMLClutterActionHandler restoreYAMLClutterActionHandler = new RestoreYAMLClutterActionHandler();
        Assert.assertFalse((boolean)restoreYAMLClutterActionHandler.isCleaned());
    }
}

