/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.devtools.intellij.common.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class VfsRootAccessHelper {
    private VfsRootAccessHelper() {
    }

    public static void allowRootAccess(Disposable disposable, String ... roots) {
        if (disposable == null) {
            disposable = () -> {};
        }
        try {
            Method method = Arrays.stream(VfsRootAccess.class.getDeclaredMethods()).filter(m -> m.getName().equals("allowRootAccess")).findFirst().get();
            if (method.getParameterCount() > 1) {
                method.invoke(null, disposable, roots);
            } else {
                method.invoke(null, new Object[]{roots});
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void allowRootAccess(String ... roots) {
        VfsRootAccessHelper.allowRootAccess(null, roots);
    }
}

