/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.InsightsScheduler;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.logging.InsightsLogger;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class InsightsCustomScheduledExecutor
extends ScheduledThreadPoolExecutor
implements InsightsScheduler {
    private final InsightsLogger logger;
    private final InsightsConfiguration configuration;

    private InsightsCustomScheduledExecutor(InsightsLogger logger, InsightsConfiguration configuration) {
        super(1);
        this.setKeepAliveTime(10L, TimeUnit.MILLISECONDS);
        this.logger = logger;
        this.configuration = configuration;
    }

    public static InsightsCustomScheduledExecutor of(InsightsLogger logger, InsightsConfiguration configuration) {
        InsightsCustomScheduledExecutor pool = new InsightsCustomScheduledExecutor(logger, configuration);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    @Override
    public ScheduledFuture<?> scheduleConnect(Runnable sendConnect) {
        return this.scheduleAtFixedRate(sendConnect, 0L, this.configuration.getConnectPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleJarUpdate(Runnable sendNewJarsIfAny) {
        return this.scheduleAtFixedRate(sendNewJarsIfAny, this.configuration.getUpdatePeriod().getSeconds(), this.configuration.getUpdatePeriod().getSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Runnable wrapped = () -> {
            try {
                command.run();
            }
            catch (InsightsException ix) {
                this.logger.error(InsightsErrorCode.ERROR_SCHEDULED_SENT.formatMessage("Red Hat Insights client scheduler shutdown, scheduled send failed: " + ix.getMessage()), ix);
                this.shutdown();
                throw ix;
            }
            catch (Throwable th) {
                this.logger.error(InsightsErrorCode.ERROR_SCHEDULED_SENT.formatMessage("Red Hat Insights client scheduler shutdown, non-Insights failure: " + th.getMessage()), th);
                this.shutdown();
                throw th;
            }
        };
        return super.scheduleAtFixedRate(wrapped, initialDelay, period, unit);
    }
}

