/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.insights.reports;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.insights.Filtering;
import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.reports.InsightsSubreport;
import com.redhat.insights.reports.ObjectMappers;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public interface InsightsReport
extends Closeable {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Map<String, InsightsSubreport> getSubreports();

    public JsonSerializer<InsightsReport> getSerializer();

    public void generateReport(Filtering var1);

    public Map<String, Object> getBasic();

    public String getVersion();

    public void setIdHash(String var1);

    public String getIdHash();

    public void decorate(String var1, String var2);

    default public byte[] serializeRaw() {
        ObjectMapper mapper = ObjectMappers.createFor(this);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)this);
        }
        catch (IOException e) {
            throw new InsightsException(InsightsErrorCode.ERROR_SERIALIZING_TO_JSON, "JSON serialization exception", e);
        }
    }

    @Deprecated
    default public String serialize() {
        ObjectMapper mapper = ObjectMappers.createFor(this);
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new InsightsException(InsightsErrorCode.ERROR_SERIALIZING_TO_JSON, "JSON serialization exception", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public byte[] getSubModulesReport() {
        ObjectMapper mapper = ObjectMappers.createFor(this);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            block18: {
                JsonGenerator generator;
                block16: {
                    byte[] byArray2;
                    block17: {
                        generator = mapper.writerWithDefaultPrettyPrinter().createGenerator((OutputStream)out);
                        try {
                            boolean notEmptyArray;
                            generator.writeStartObject();
                            for (Map.Entry<String, InsightsSubreport> entry : this.getSubreports().entrySet()) {
                                generator.writeObjectField(entry.getKey(), (Object)entry.getValue());
                            }
                            generator.writeEndObject();
                            generator.flush();
                            byte[] report = out.toByteArray();
                            boolean bl = notEmptyArray = report.length > 3;
                            if (!notEmptyArray) break block16;
                            byte[] finalReport = new byte[report.length - 1];
                            finalReport[0] = 44;
                            System.arraycopy(report, 1, finalReport, 1, report.length - 2);
                            byArray2 = finalReport;
                            if (generator == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (generator != null) {
                                try {
                                    generator.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        generator.close();
                    }
                    return byArray2;
                }
                byArray = EMPTY_BYTE_ARRAY;
                if (generator == null) break block18;
                generator.close();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new InsightsException(InsightsErrorCode.ERROR_SERIALIZING_TO_JSON, "JSON serialization exception", e);
        }
    }
}

