/*******************************************************************************
* Copyright (c) 2021 Red Hat Inc. and others.
* All rights reserved. This program and the accompanying materials
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* SPDX-License-Identifier: EPL-2.0
*
* Contributors:
*     Red Hat Inc. - initial API and implementation
*******************************************************************************/
package com.redhat.qute.settings;

public class QuteCodeLensSettings {

	private boolean enabled;

	public QuteCodeLensSettings() {
		setEnabled(true);
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	/**
	 * Returns true if codelens support is enabled and false otherwise.
	 * 
	 * @return true if codelens support is enabled and false otherwise.
	 */
	public boolean isEnabled() {
		return enabled;
	}

	public void update(QuteCodeLensSettings newCodeLens) {
		this.setEnabled(newCodeLens.isEnabled());
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (enabled ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		QuteCodeLensSettings other = (QuteCodeLensSettings) obj;
		if (enabled != other.enabled)
			return false;
		return true;
	}

}
