/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JavaFieldInfo
extends JavaMemberInfo {
    private transient String name;
    private transient String type;

    @Override
    public String getSignature() {
        return super.getSignature();
    }

    public String getSimpleSignature() {
        return this.getName() + " : " + this.getJavaElementSimpleType();
    }

    @Override
    public String getName() {
        int index;
        if (this.name != null) {
            return this.name;
        }
        String signature = this.getSignature();
        int n = index = signature != null ? signature.indexOf(58) : -1;
        if (index != -1) {
            this.name = signature.substring(0, index).trim();
        }
        return this.name;
    }

    public String getType() {
        if (this.type == null) {
            String signature = this.getSignature();
            int index = signature.lastIndexOf(58);
            this.type = index != -1 ? signature.substring(index + 1, signature.length()).trim() : "~";
        }
        return "~".equals(this.type) ? null : this.type;
    }

    @Override
    public JavaElementKind getJavaElementKind() {
        return JavaElementKind.FIELD;
    }

    @Override
    public String getJavaElementType() {
        return this.getType();
    }

    public static JavaFieldInfo applyGenericTypeInvocation(JavaFieldInfo field, Map<String, String> genericMap) {
        JavaFieldInfo newField = new JavaFieldInfo();
        StringBuilder newSignature = new StringBuilder();
        newSignature.append(field.getName());
        newSignature.append(" : ");
        JavaTypeInfo.applyGenericTypeInvocation(field.getType(), genericMap, newSignature);
        newField.setSignature(newSignature.toString());
        newField.setGenericMember(field);
        return newField;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.getName());
        b.add("type", (Object)this.getType());
        b.add("signature", (Object)this.getSignature());
        return b.toString();
    }
}

