/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaElementInfo;
import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JavaTypeInfo
extends JavaElementInfo {
    public static final List<String> PRIMITIVE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long");
    private JavaTypeKind typeKind;
    private List<JavaParameterInfo> parameters;
    private String name;
    private Map<String, InvalidMethodReason> invalidMethods;

    @Override
    public String getSignature() {
        return super.getSignature();
    }

    @Override
    public String getName() {
        this.getTypeParameters();
        return this.name;
    }

    @Override
    public String getJavaElementType() {
        return this.getSignature();
    }

    @Override
    public JavaElementKind getJavaElementKind() {
        return JavaElementKind.TYPE;
    }

    public JavaTypeKind getJavaTypeKind() {
        return this.typeKind;
    }

    public void setJavaTypeKind(JavaTypeKind kind) {
        this.typeKind = kind;
    }

    public InvalidMethodReason getInvalidMethodReason(String methodName) {
        return this.invalidMethods != null ? this.invalidMethods.get(methodName) : null;
    }

    public void setInvalidMethod(String methodName, InvalidMethodReason reason) {
        if (this.invalidMethods == null) {
            this.setInvalidMethods(new HashMap<String, InvalidMethodReason>());
        }
        this.invalidMethods.put(methodName, reason);
    }

    public void setInvalidMethods(Map<String, InvalidMethodReason> invalidMethods) {
        this.invalidMethods = invalidMethods;
    }

    public Map<String, InvalidMethodReason> getInvalidMethods() {
        return this.invalidMethods;
    }

    public List<JavaParameterInfo> getTypeParameters() {
        if (this.parameters == null) {
            String signature = super.getSignature();
            int index = signature.indexOf(60);
            if (index == -1) {
                this.name = signature;
                this.parameters = Collections.emptyList();
            } else {
                this.name = signature.substring(0, index);
                this.parameters = JavaTypeInfo.parseTypeParameters(signature, index);
            }
        }
        return this.parameters;
    }

    private static List<JavaParameterInfo> parseTypeParameters(String signature, int start) {
        ArrayList<JavaParameterInfo> parameters = new ArrayList<JavaParameterInfo>();
        int end = signature.lastIndexOf(62);
        StringBuilder paramName = new StringBuilder();
        boolean ignore = false;
        block5: for (int i = start + 1; i < end; ++i) {
            char c = signature.charAt(i);
            switch (c) {
                case '<': {
                    ignore = true;
                    paramName.append(c);
                    continue block5;
                }
                case '>': {
                    ignore = false;
                    paramName.append(c);
                    continue block5;
                }
                case ',': {
                    if (ignore) {
                        paramName.append(c);
                        continue block5;
                    }
                    parameters.add(new JavaParameterInfo(null, paramName.toString()));
                    paramName.setLength(0);
                    continue block5;
                }
                default: {
                    paramName.append(c);
                }
            }
        }
        if (paramName.length() > 0) {
            parameters.add(new JavaParameterInfo(null, paramName.toString()));
        }
        return parameters;
    }

    public boolean isGenericType() {
        if (this.isSingleGenericType()) {
            return true;
        }
        for (JavaParameterInfo parameter : this.getTypeParameters()) {
            if (!JavaTypeInfo.isTypeParameterName(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleGenericType() {
        return this.getTypeParameters().isEmpty() && JavaTypeInfo.isTypeParameterName(this.getName());
    }

    private static boolean isTypeParameterName(String type) {
        int index = type.indexOf(91);
        if (index != -1) {
            return JavaTypeInfo.isTypeParameterName(type.substring(0, index));
        }
        return type.indexOf(46) == -1 && !PRIMITIVE_TYPES.contains(type);
    }

    public boolean isArray() {
        return this.getName().endsWith("[]");
    }

    public static String applyGenericTypeInvocation(JavaTypeInfo javaType, Map<String, String> genericMap) {
        StringBuilder result = new StringBuilder();
        JavaTypeInfo.applyGenericTypeInvocation(javaType, genericMap, result);
        return result.toString();
    }

    public static void applyGenericTypeInvocation(JavaTypeInfo javaType, Map<String, String> genericMap, StringBuilder result) {
        List<JavaParameterInfo> parameters = javaType.getTypeParameters();
        if (!parameters.isEmpty()) {
            result.append(javaType.getName());
            result.append("<");
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    result.append(",");
                }
                JavaParameterInfo parameter = parameters.get(i);
                String type = parameter.getType();
                JavaTypeInfo.applyGenericTypeInvocation(type, genericMap, result);
            }
            result.append(">");
        } else {
            JavaTypeInfo.applyGenericTypeInvocation(javaType.getName(), genericMap, result);
        }
    }

    public static String applyGenericTypeInvocation(String javaType, Map<String, String> genericMap) {
        StringBuilder result = new StringBuilder();
        JavaTypeInfo.applyGenericTypeInvocation(javaType, genericMap, result);
        return result.toString();
    }

    public static void applyGenericTypeInvocation(String javaType, Map<String, String> genericMap, StringBuilder result) {
        String paramType = genericMap.getOrDefault(javaType, javaType);
        if (JavaTypeInfo.containsGenericParameter(paramType)) {
            JavaTypeInfo subType = new JavaTypeInfo();
            subType.setSignature(paramType);
            JavaTypeInfo.applyGenericTypeInvocation(subType, genericMap, result);
        } else {
            result.append(paramType);
        }
    }

    private static boolean containsGenericParameter(String javaType) {
        return javaType != null && javaType.indexOf(60) != -1;
    }

    public Map<String, String> createGenericMap(String javaType) {
        if (javaType.indexOf(60) == -1) {
            return null;
        }
        JavaTypeInfo typeInfo = new JavaTypeInfo();
        typeInfo.setSignature(javaType);
        LinkedHashMap<String, String> generics = new LinkedHashMap<String, String>();
        List<JavaParameterInfo> typeParameters = typeInfo.getTypeParameters();
        int size = Math.min(typeParameters.size(), this.getTypeParameters().size());
        for (int i = 0; i < size; ++i) {
            generics.put(this.getTypeParameters().get(i).getType(), typeParameters.get(i).getType());
        }
        return generics;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.getName());
        b.add("signature", (Object)this.getSignature());
        b.add("array", (Object)this.isArray());
        b.add("genericType", (Object)this.isGenericType());
        return b.toString();
    }
}

