/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum QuteProjectScope {
    sources(1),
    dependencies(2);

    private final int value;
    public static final List<QuteProjectScope> ONLY_SOURCES;
    public static final List<QuteProjectScope> SOURCES_AND_DEPENDENCIES;

    private QuteProjectScope(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static QuteProjectScope forValue(int value) {
        QuteProjectScope[] allValues = QuteProjectScope.values();
        if (value < 1 || value > allValues.length) {
            throw new IllegalArgumentException("Illegal enum value: " + value);
        }
        return allValues[value - 1];
    }

    public static boolean isOnlySources(List<QuteProjectScope> scopes) {
        return scopes != null && scopes.size() == 1 && scopes.get(0) == sources;
    }

    static {
        ONLY_SOURCES = Collections.singletonList(sources);
        SOURCES_AND_DEPENDENCIES = Arrays.asList(sources, dependencies);
    }
}

