/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.JavaTypeKind;
import com.redhat.qute.commons.annotations.RegisterForReflectionAnnotation;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class ResolvedJavaTypeInfo
extends JavaTypeInfo {
    private static final String ITERABLE_TYPE = "Iterable";
    private static final String JAVA_LANG_ITERABLE_TYPE = "java.lang.Iterable";
    private static final List<String> WRAPPER_TYPES = Arrays.asList("java.util.concurrent.CompletionStage", "io.smallrye.mutiny.Uni");
    private List<String> extendedTypes;
    private List<JavaFieldInfo> fields;
    private List<JavaMethodInfo> methods;
    private Boolean binary;
    private RegisterForReflectionAnnotation registerForReflectionAnnotation;
    private List<TemplateDataAnnotation> templateDataAnnotations;
    private transient String iterableOf;
    private transient Boolean isIterable;
    private transient Boolean isWrapperType;

    public List<String> getExtendedTypes() {
        return this.extendedTypes;
    }

    public void setExtendedTypes(List<String> extendedTypes) {
        this.extendedTypes = extendedTypes;
    }

    public List<JavaFieldInfo> getFields() {
        return this.fields != null ? this.fields : Collections.emptyList();
    }

    protected boolean isFieldsInitialized() {
        return this.fields != null;
    }

    public void setFields(List<JavaFieldInfo> fields) {
        this.fields = fields;
    }

    public List<JavaMethodInfo> getMethods() {
        return this.methods != null ? this.methods : Collections.emptyList();
    }

    protected boolean isMethodsInitialized() {
        return this.methods != null;
    }

    public void setMethods(List<JavaMethodInfo> methods) {
        this.methods = methods;
    }

    public void setIterableOf(String iterableOf) {
        this.iterableOf = iterableOf;
    }

    public String getIterableOf() {
        if (this.iterableOf == null && this.isArray()) {
            this.iterableOf = this.getName().substring(0, this.getName().length() - 2);
        }
        return this.iterableOf;
    }

    public boolean isIterable() {
        if (this.isArray()) {
            return true;
        }
        if (this.isIterable != null) {
            return this.isIterable;
        }
        this.isIterable = this.computeIsIterable();
        return this.isIterable;
    }

    public boolean isWrapperType() {
        if (this.isWrapperType != null) {
            return this.isWrapperType;
        }
        this.isWrapperType = this.computeIsWrappedObject();
        return this.isWrapperType;
    }

    private synchronized boolean computeIsWrappedObject() {
        if (this.isWrapperType != null) {
            return this.isWrapperType;
        }
        boolean wrapperType = ResolvedJavaTypeInfo.isWrapperType(this.getName());
        if (!wrapperType && this.extendedTypes != null) {
            for (String extendedType : this.extendedTypes) {
                if (!ResolvedJavaTypeInfo.isWrapperType(extendedType)) continue;
                wrapperType = true;
                break;
            }
        }
        return wrapperType;
    }

    public static boolean isWrapperType(String type) {
        return WRAPPER_TYPES.contains(type);
    }

    public void setWrapperType(Boolean wrapperType) {
        this.isWrapperType = wrapperType;
    }

    public boolean isBinary() {
        return this.binary != null && this.binary != false;
    }

    public void setBinary(Boolean binary) {
        this.binary = binary;
    }

    public boolean isInteger() {
        String name = this.getName();
        return "int".equals(name) || "java.lang.Integer".equals(name);
    }

    private synchronized boolean computeIsIterable() {
        if (this.isIterable != null) {
            return this.isIterable;
        }
        if (this.iterableOf != null) {
            return true;
        }
        boolean iterable = this.getName().equals(JAVA_LANG_ITERABLE_TYPE);
        if (!iterable && this.extendedTypes != null) {
            for (String extendedType : this.extendedTypes) {
                if (!ResolvedJavaTypeInfo.isIterable(extendedType)) continue;
                iterable = true;
                break;
            }
        }
        if (iterable) {
            List<JavaParameterInfo> typeParameters = this.getTypeParameters();
            this.iterableOf = !typeParameters.isEmpty() ? typeParameters.get(0).getType() : "java.lang.Object";
        }
        return iterable;
    }

    public static boolean isIterable(String type) {
        return ITERABLE_TYPE.equals(type) || JAVA_LANG_ITERABLE_TYPE.equals(type);
    }

    public List<TemplateDataAnnotation> getTemplateDataAnnotations() {
        return this.templateDataAnnotations;
    }

    public void setTemplateDataAnnotations(List<TemplateDataAnnotation> templateDataAnnotations) {
        this.templateDataAnnotations = templateDataAnnotations;
    }

    public RegisterForReflectionAnnotation getRegisterForReflectionAnnotation() {
        return this.registerForReflectionAnnotation;
    }

    public void setRegisterForReflectionAnnotation(RegisterForReflectionAnnotation registerForReflectionAnnotation) {
        this.registerForReflectionAnnotation = registerForReflectionAnnotation;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.getName());
        b.add("signature", (Object)this.getSignature());
        b.add("binary", (Object)(this.isBinary() ? "BINARY" : "SOURCE"));
        b.add("iterableOf", (Object)this.getIterableOf());
        b.add("templateDataAnnotations", this.getTemplateDataAnnotations());
        b.add("registerForReflectionAnnotation", (Object)this.getRegisterForReflectionAnnotation());
        return b.toString();
    }

    public boolean isUnknown() {
        return this.getJavaTypeKind() == JavaTypeKind.Unknown;
    }

    public boolean isPackage() {
        return this.getJavaTypeKind() == JavaTypeKind.Package;
    }

    public boolean isClass() {
        return this.getJavaTypeKind() == JavaTypeKind.Class;
    }

    public boolean isInterface() {
        return this.getJavaTypeKind() == JavaTypeKind.Interface;
    }

    public boolean isEnum() {
        return this.getJavaTypeKind() == JavaTypeKind.Enum;
    }
}

