/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class TemplateDataAnnotation {
    private Boolean ignoreSuperclasses;
    private String target;
    private List<String> ignore;
    private Boolean properties;

    public boolean isIgnoreSuperclasses() {
        return this.ignoreSuperclasses != null && this.ignoreSuperclasses != false;
    }

    public void setIgnoreSuperclasses(Boolean ignoreSuperclasses) {
        this.ignoreSuperclasses = ignoreSuperclasses;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
    }

    public static List<Pattern> createIgnorePatterns(Collection<String> ignore) {
        if (ignore == null || ignore.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> ignorePatterns = new ArrayList<Pattern>(ignore.size());
        for (String ignoreItem : ignore) {
            try {
                ignorePatterns.add(Pattern.compile(ignoreItem));
            }
            catch (Exception exception) {}
        }
        return ignorePatterns;
    }

    public static String getMatchedIgnorePattern(String name, Collection<Pattern> ignorePatterns) {
        for (Pattern ignorePattern : ignorePatterns) {
            if (!ignorePattern.matcher(name).matches()) continue;
            return ignorePattern.pattern();
        }
        return null;
    }

    public boolean isProperties() {
        return this.properties != null && this.properties != false;
    }

    public void setProperties(Boolean properties) {
        this.properties = properties;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("ignoreSuperclasses", (Object)this.isIgnoreSuperclasses());
        b.add("target", (Object)this.getTarget());
        b.add("ignore", this.getIgnore());
        b.add("properties", (Object)this.isProperties());
        return b.toString();
    }
}

