/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls;

import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.qute.settings.SharedSettings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public abstract class AbstractTextDocumentService
implements TextDocumentService {
    protected final QuteLanguageServer quteLanguageServer;
    protected final SharedSettings sharedSettings;
    private boolean hierarchicalDocumentSymbolSupport;
    private boolean definitionLinkSupport;
    private boolean codeActionLiteralSupport;

    public AbstractTextDocumentService(QuteLanguageServer quteLanguageServer, SharedSettings sharedSettings) {
        this.quteLanguageServer = quteLanguageServer;
        this.sharedSettings = sharedSettings;
    }

    public void updateClientCapabilities(ClientCapabilities capabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
        if (textDocumentClientCapabilities != null) {
            this.sharedSettings.getHoverSettings().setCapabilities(textDocumentClientCapabilities.getHover());
            this.sharedSettings.getCompletionSettings().setCapabilities(textDocumentClientCapabilities.getCompletion());
            this.hierarchicalDocumentSymbolSupport = textDocumentClientCapabilities.getDocumentSymbol() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != false;
            this.definitionLinkSupport = textDocumentClientCapabilities.getDefinition() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != false;
            boolean bl = this.codeActionLiteralSupport = textDocumentClientCapabilities.getCodeAction() != null && textDocumentClientCapabilities.getCodeAction().getCodeActionLiteralSupport() != null;
        }
        if (extendedClientCapabilities != null) {
            this.sharedSettings.getCommandCapabilities().setCapabilities(extendedClientCapabilities.getCommands());
        }
    }

    public abstract FileType getFileType();

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<LinkedEditingRanges> linkedEditingRange(LinkedEditingRangeParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return CompletableFuture.completedFuture(null);
    }

    public boolean isHierarchicalDocumentSymbolSupport() {
        return this.hierarchicalDocumentSymbolSupport;
    }

    public boolean isDefinitionLinkSupport() {
        return this.definitionLinkSupport;
    }

    public boolean isCodeActionLiteralSupport() {
        return this.codeActionLiteralSupport;
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    public static enum FileType {
        TEMPLATE,
        JAVA;

    }
}

