/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls;

import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ProjectInfo;
import com.redhat.qute.commons.QuteJavaDefinitionParams;
import com.redhat.qute.commons.QuteJavaTypesParams;
import com.redhat.qute.commons.QuteJavadocParams;
import com.redhat.qute.commons.QuteProjectParams;
import com.redhat.qute.commons.QuteResolvedJavaTypeParams;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.JavaDataModelChangeEvent;
import com.redhat.qute.commons.datamodel.QuteDataModelProjectParams;
import com.redhat.qute.commons.usertags.QuteUserTagParams;
import com.redhat.qute.commons.usertags.UserTagInfo;
import com.redhat.qute.ls.QuteTextDocumentService;
import com.redhat.qute.ls.QuteWorkspaceService;
import com.redhat.qute.ls.TelemetrySupport;
import com.redhat.qute.ls.api.QuteDataModelProjectProvider;
import com.redhat.qute.ls.api.QuteJavaDefinitionProvider;
import com.redhat.qute.ls.api.QuteJavaTypesProvider;
import com.redhat.qute.ls.api.QuteJavadocProvider;
import com.redhat.qute.ls.api.QuteLanguageClientAPI;
import com.redhat.qute.ls.api.QuteLanguageServerAPI;
import com.redhat.qute.ls.api.QuteProjectInfoProvider;
import com.redhat.qute.ls.api.QuteResolvedJavaTypeProvider;
import com.redhat.qute.ls.api.QuteTemplateProvider;
import com.redhat.qute.ls.api.QuteUserTagProvider;
import com.redhat.qute.ls.commons.ParentProcessWatcher;
import com.redhat.qute.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.qute.ls.commons.client.InitializationOptionsExtendedClientCapabilities;
import com.redhat.qute.ls.template.TemplateFileTextDocumentService;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.project.ProgressSupport;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteProjectRegistry;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.TemplateValidator;
import com.redhat.qute.services.QuteLanguageService;
import com.redhat.qute.settings.AllQuteSettings;
import com.redhat.qute.settings.InitializationOptionsSettings;
import com.redhat.qute.settings.QuteGeneralClientSettings;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.settings.capabilities.QuteCapabilityManager;
import com.redhat.qute.settings.capabilities.ServerCapabilitiesInitializer;
import com.redhat.qute.utils.VersionHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;

public class QuteLanguageServer
implements LanguageServer,
ParentProcessWatcher.ProcessLanguageServer,
QuteLanguageServerAPI,
QuteProjectInfoProvider,
QuteJavaTypesProvider,
QuteResolvedJavaTypeProvider,
QuteJavaDefinitionProvider,
QuteDataModelProjectProvider,
QuteUserTagProvider,
QuteJavadocProvider,
QuteTemplateProvider,
TemplateValidator,
ProgressSupport,
TelemetrySupport {
    private static final Logger LOGGER = Logger.getLogger(QuteLanguageServer.class.getName());
    private final SharedSettings sharedSettings = new SharedSettings();
    private final QuteProjectRegistry projectRegistry = new QuteProjectRegistry(this, this, this, this, this, this, this, this, () -> this.capabilityManager.getClientCapabilities().isWorkDoneProgressSupported() ? this : null);
    private final QuteLanguageService quteLanguageService = new QuteLanguageService(this.projectRegistry);
    private final QuteTextDocumentService textDocumentService = new QuteTextDocumentService(this);
    private final QuteWorkspaceService workspaceService = new QuteWorkspaceService(this);
    private Integer parentProcessId;
    private QuteLanguageClientAPI languageClient;
    private QuteCapabilityManager capabilityManager;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        LOGGER.info("Initializing Qute server " + VersionHelper.getVersion() + " with " + System.getProperty("java.home"));
        this.parentProcessId = params.getProcessId();
        ExtendedClientCapabilities extendedClientCapabilities = InitializationOptionsExtendedClientCapabilities.getExtendedClientCapabilities(params);
        this.capabilityManager.setClientCapabilities(params.getCapabilities(), extendedClientCapabilities);
        this.updateSettings(InitializationOptionsSettings.getSettings(params));
        this.textDocumentService.updateClientCapabilities(params.getCapabilities(), extendedClientCapabilities);
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities(this.capabilityManager.getClientCapabilities());
        this.projectRegistry.setDidChangeWatchedFilesSupported(this.capabilityManager.getClientCapabilities().isDidChangeWatchedFilesRegistered());
        InitializeResult initializeResult = new InitializeResult(serverCapabilities);
        return CompletableFuture.completedFuture(initializeResult);
    }

    public void initialized(InitializedParams params) {
        this.capabilityManager.initializeCapabilities();
        this.getCapabilityManager().registerExecuteCommand(this.getWorkspaceService().getCommandIds());
        this.loadQuteProjects();
    }

    private void loadQuteProjects() {
        this.getLanguageClient().getProjects().thenAccept(projects -> {
            if (projects != null && !projects.isEmpty()) {
                this.projectRegistry.loadQuteProjects((Collection<ProjectInfo>)projects);
            }
        });
    }

    public synchronized void updateSettings(Object initializationOptionsSettings) {
        if (initializationOptionsSettings == null) {
            return;
        }
        QuteGeneralClientSettings clientSettings = QuteGeneralClientSettings.getGeneralQuteSettings(initializationOptionsSettings = AllQuteSettings.getQuteSettings(initializationOptionsSettings));
        if (clientSettings != null) {
            QuteGeneralClientSettings.SettingsUpdateState result = QuteGeneralClientSettings.update(this.getSharedSettings(), clientSettings);
            if (result.isCodeLensSettingsChanged()) {
                this.getLanguageClient().refreshCodeLenses();
            }
            if (result.isInlayHintSettingsChanged()) {
                this.getLanguageClient().refreshInlayHints();
            }
            if (result.isValidationSettingsChanged() || result.isNativeImagesSettingsChanged()) {
                this.textDocumentService.validationSettingsChanged();
            }
        }
    }

    public CompletableFuture<Object> shutdown() {
        if (this.capabilityManager.getClientCapabilities().shouldLanguageServerExitOnShutdown()) {
            ScheduledExecutorService delayer = Executors.newScheduledThreadPool(1);
            delayer.schedule(() -> this.exit(0), 1L, TimeUnit.SECONDS);
        }
        this.textDocumentService.dispose();
        this.projectRegistry.dispose();
        return CompletableFutures.computeAsync(cc -> new Object());
    }

    public void exit() {
        this.exit(0);
    }

    @Override
    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public QuteWorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public QuteLanguageClientAPI getLanguageClient() {
        return this.languageClient;
    }

    public QuteCapabilityManager getCapabilityManager() {
        return this.capabilityManager;
    }

    public void setClient(LanguageClient languageClient) {
        this.languageClient = (QuteLanguageClientAPI)languageClient;
        this.capabilityManager = new QuteCapabilityManager(languageClient);
    }

    @Override
    public long getParentProcessId() {
        return this.parentProcessId != null ? (long)this.parentProcessId.intValue() : 0L;
    }

    public QuteLanguageService getQuteLanguageService() {
        return this.quteLanguageService;
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    @Override
    public CompletableFuture<Collection<ProjectInfo>> getProjects() {
        return this.getLanguageClient().getProjects();
    }

    @Override
    public void projectAdded(ProjectInfo project) {
        this.projectRegistry.projectAdded(project);
    }

    @Override
    public void projectRemoved(ProjectInfo project) {
        this.projectRegistry.projectRemoved(project);
    }

    @Override
    public CompletableFuture<ProjectInfo> getProjectInfo(QuteProjectParams params) {
        return this.getLanguageClient().getProjectInfo(params);
    }

    @Override
    public CompletableFuture<List<JavaTypeInfo>> getJavaTypes(QuteJavaTypesParams params) {
        return this.getLanguageClient().getJavaTypes(params);
    }

    @Override
    public CompletableFuture<Location> getJavaDefinition(QuteJavaDefinitionParams params) {
        return this.getLanguageClient().getJavaDefinition(params);
    }

    @Override
    public CompletableFuture<ResolvedJavaTypeInfo> getResolvedJavaType(QuteResolvedJavaTypeParams params) {
        return this.getLanguageClient().getResolvedJavaType(params);
    }

    @Override
    public CompletableFuture<String> getJavadoc(QuteJavadocParams params) {
        return this.getLanguageClient().getJavadoc(params);
    }

    @Override
    public void dataModelChanged(JavaDataModelChangeEvent event) {
        this.projectRegistry.dataModelChanged(event);
        this.textDocumentService.dataModelChanged(event);
    }

    public QuteProjectRegistry getProjectRegistry() {
        return this.projectRegistry;
    }

    @Override
    public CompletableFuture<DataModelProject<DataModelTemplate<DataModelParameter>>> getDataModelProject(QuteDataModelProjectParams params) {
        return this.getLanguageClient().getDataModelProject(params);
    }

    @Override
    public CompletableFuture<List<UserTagInfo>> getUserTags(QuteUserTagParams params) {
        return this.getLanguageClient().getUserTags(params);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.textDocumentService.didChangeWatchedFiles(params);
    }

    public void setTrace(SetTraceParams params) {
    }

    @Override
    public Template getTemplate(String uri) {
        return ((TemplateFileTextDocumentService)this.textDocumentService.getTextDocumentService(uri)).getTemplate(uri);
    }

    @Override
    public void triggerValidationFor(QuteTextDocument document) {
        this.textDocumentService.triggerValidationFor(document);
    }

    @Override
    public void clearDiagnosticsFor(String fileUri) {
        this.textDocumentService.clearDiagnosticsFor(fileUri);
    }

    @Override
    public void triggerValidationFor(Collection<QuteProject> projects) {
        this.textDocumentService.triggerValidationFor(projects);
    }

    @Override
    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return this.getLanguageClient().createProgress(params);
    }

    @Override
    public void notifyProgress(String progressId, WorkDoneProgressNotification notification) {
        ProgressParams params = new ProgressParams(Either.forLeft((Object)progressId), Either.forRight((Object)notification));
        this.getLanguageClient().notifyProgress(params);
    }

    @Override
    public void telemetryEvent(Object object) {
        this.getLanguageClient().telemetryEvent(object);
    }
}

