/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls;

import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.ls.api.QuteLanguageClientAPI;
import com.redhat.qute.ls.commons.ParentProcessWatcher;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class QuteServerLauncher {
    public static void main(String[] args) {
        QuteLanguageServer server = new QuteLanguageServer();
        ParentProcessWatcher wrapper = it -> it;
        if ("true".equals(System.getProperty("runAsync"))) {
            wrapper = it -> msg -> CompletableFuture.runAsync(() -> it.consume(msg));
        }
        if (!"false".equals(System.getProperty("watchParentProcess"))) {
            wrapper = new ParentProcessWatcher(server, wrapper);
        }
        Launcher<LanguageClient> launcher = QuteServerLauncher.createServerLauncher(server, System.in, System.out, Executors.newCachedThreadPool(), wrapper);
        server.setClient((LanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    public static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(QuteLanguageClientAPI.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }
}

