/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls;

import com.redhat.qute.commons.datamodel.JavaDataModelChangeEvent;
import com.redhat.qute.ls.AbstractTextDocumentService;
import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.ls.commons.client.ExtendedClientCapabilities;
import com.redhat.qute.ls.java.JavaFileTextDocumentService;
import com.redhat.qute.ls.template.TemplateFileTextDocumentService;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.TemplateValidator;
import com.redhat.qute.services.codeactions.CodeActionUnresolvedData;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.JSONUtility;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class QuteTextDocumentService
implements TextDocumentService,
TemplateValidator {
    private final SharedSettings sharedSettings;
    private final JavaFileTextDocumentService javaFileTextDocumentService;
    private final TemplateFileTextDocumentService templateFileTextDocumentService;

    public QuteTextDocumentService(QuteLanguageServer quteLanguageServer) {
        this.sharedSettings = quteLanguageServer.getSharedSettings();
        this.javaFileTextDocumentService = new JavaFileTextDocumentService(quteLanguageServer, this.sharedSettings);
        this.templateFileTextDocumentService = new TemplateFileTextDocumentService(quteLanguageServer, this.sharedSettings);
    }

    public void updateClientCapabilities(ClientCapabilities capabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
        if (textDocumentClientCapabilities != null) {
            this.sharedSettings.getCompletionSettings().setCapabilities(textDocumentClientCapabilities.getCompletion());
            this.sharedSettings.getCodeActionSettings().setCapabilities(textDocumentClientCapabilities.getCodeAction());
        }
        this.templateFileTextDocumentService.updateClientCapabilities(capabilities, extendedClientCapabilities);
        this.javaFileTextDocumentService.updateClientCapabilities(capabilities);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        TextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didOpen(params);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService((TextDocumentIdentifier)params.getTextDocument());
        if (service != null) {
            service.didChange(params);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didClose(params);
        }
    }

    public void didSave(DidSaveTextDocumentParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            service.didSave(params);
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        AbstractTextDocumentService service = this.getTextDocumentService(position.getTextDocument());
        if (service != null) {
            return service.completion(position);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.hover(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.documentSymbol(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.definition(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.formatting(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.rangeFormatting(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.codeAction(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.codeLens(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.documentHighlight(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.documentLink(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.references(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.rename(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<LinkedEditingRanges> linkedEditingRange(LinkedEditingRangeParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.linkedEditingRange(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        AbstractTextDocumentService service = this.getTextDocumentService(params.getTextDocument());
        if (service != null) {
            return service.inlayHint(params);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction codeAction) {
        TextDocumentIdentifier textDocument;
        AbstractTextDocumentService service;
        CodeActionUnresolvedData data = JSONUtility.toModel(codeAction.getData(), CodeActionUnresolvedData.class);
        if (data != null && (service = this.getTextDocumentService(textDocument = new TextDocumentIdentifier(data.getTextDocumentUri()))) != null) {
            return service.resolveCodeAction(codeAction);
        }
        return CompletableFuture.completedFuture(null);
    }

    public AbstractTextDocumentService getTextDocumentService(TextDocumentIdentifier document) {
        return this.getTextDocumentService(document.getUri());
    }

    private TextDocumentService getTextDocumentService(TextDocumentItem document) {
        return this.getTextDocumentService(document.getUri());
    }

    public AbstractTextDocumentService getTextDocumentService(String uri) {
        String fileExtension = QuteTextDocumentService.getFileExtension(uri);
        if ("java".equals(fileExtension) || "class".equals(fileExtension)) {
            return this.javaFileTextDocumentService;
        }
        return this.templateFileTextDocumentService;
    }

    private static String getFileExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int index = uri.lastIndexOf(46);
        return index != -1 ? uri.substring(index + 1, uri.length()) : null;
    }

    public void dataModelChanged(JavaDataModelChangeEvent event) {
        this.templateFileTextDocumentService.dataModelChanged(event);
    }

    public void validationSettingsChanged() {
        this.templateFileTextDocumentService.validationSettingsChanged();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.templateFileTextDocumentService.didChangeWatchedFiles(params);
    }

    @Override
    public void triggerValidationFor(QuteTextDocument document) {
        this.templateFileTextDocumentService.triggerValidationFor(document);
    }

    @Override
    public void clearDiagnosticsFor(String fileUri) {
        this.templateFileTextDocumentService.clearDiagnosticsFor(fileUri);
    }

    @Override
    public void triggerValidationFor(Collection<QuteProject> projects) {
        this.templateFileTextDocumentService.triggerValidationFor(projects);
    }

    public void dispose() {
        this.templateFileTextDocumentService.dispose();
        this.javaFileTextDocumentService.dispose();
    }
}

