/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls;

import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.services.commands.IDelegateCommandHandler;
import com.redhat.qute.services.commands.QuteGenerateCommandHandler;
import com.redhat.qute.services.commands.QuteGenerateTemplateContentCommandHandler;
import com.redhat.qute.services.commands.QuteSurroundWithCommandHandler;
import com.redhat.qute.services.commands.validation.QuteTemplateValidationStatusCommandHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.WorkspaceService;

public class QuteWorkspaceService
implements WorkspaceService {
    private final Map<String, IDelegateCommandHandler> commands;
    private final QuteLanguageServer quteLanguageServer;

    public QuteWorkspaceService(QuteLanguageServer quteLanguageServer) {
        this.quteLanguageServer = quteLanguageServer;
        this.commands = this.registerCommands();
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.quteLanguageServer.updateSettings(params.getSettings());
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.quteLanguageServer.didChangeWatchedFiles(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Map<String, IDelegateCommandHandler> map = this.commands;
        synchronized (map) {
            IDelegateCommandHandler handler = this.commands.get(params.getCommand());
            if (handler == null) {
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, "No command handler for the command: " + params.getCommand(), null));
            }
            return QuteWorkspaceService.computeAsync(cancelChecker -> {
                try {
                    return handler.executeCommand(params, this.quteLanguageServer.getSharedSettings(), (CancelChecker)cancelChecker);
                }
                catch (Exception e) {
                    if (e instanceof ResponseErrorException) {
                        throw (ResponseErrorException)e;
                    }
                    if (e instanceof CancellationException) {
                        throw (CancellationException)e;
                    }
                    throw new ResponseErrorException(new ResponseError(ResponseErrorCode.UnknownErrorCode, e.getMessage(), (Object)e));
                }
            });
        }
    }

    private Map<String, IDelegateCommandHandler> registerCommands() {
        HashMap<String, IDelegateCommandHandler> commands = new HashMap<String, IDelegateCommandHandler>();
        commands.put("qute.command.validation.template.status", new QuteTemplateValidationStatusCommandHandler());
        commands.put("qute.generate", new QuteGenerateCommandHandler());
        commands.put("qute.command.generate.template.content", new QuteGenerateTemplateContentCommandHandler(this.quteLanguageServer.getProjectRegistry()));
        commands.put("qute.refactor.surround.with", new QuteSurroundWithCommandHandler(this.quteLanguageServer));
        return commands;
    }

    public List<String> getCommandIds() {
        return new ArrayList<String>(this.commands.keySet());
    }

    public static <R> CompletableFuture<R> computeAsync(Function<CancelChecker, CompletableFuture<R>> code) {
        CompletableFuture<CompletableFutures.FutureCancelChecker> start = new CompletableFuture<CompletableFutures.FutureCancelChecker>();
        CompletionStage result = start.thenComposeAsync(cancelChecker -> (CompletionStage)code.apply((CancelChecker)cancelChecker));
        start.complete(new CompletableFutures.FutureCancelChecker((CompletableFuture)result));
        return result;
    }
}

