/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionFactory {
    public static CodeAction remove(String title, Range range, TextDocumentItem document, Diagnostic diagnostic) {
        return CodeActionFactory.replace(title, range, "", document, diagnostic);
    }

    public static CodeAction insert(String title, Position position, String insertText, TextDocumentItem document, Diagnostic diagnostic) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(Arrays.asList(diagnostic));
        TextDocumentEdit textDocumentEdit = CodeActionFactory.insertEdit(insertText, position, document);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static TextDocumentEdit insertEdit(String insertText, Position position, TextDocumentItem document) {
        TextEdit edit = CodeActionFactory.insertEdit(insertText, position);
        return CodeActionFactory.insertEdits(document, Collections.singletonList(edit));
    }

    public static TextEdit insertEdit(String insertText, Position position) {
        return new TextEdit(new Range(position, position), insertText);
    }

    public static TextDocumentEdit insertEdits(TextDocumentItem document, List<TextEdit> edits) {
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        return new TextDocumentEdit(versionedTextDocumentIdentifier, edits);
    }

    public static CodeAction replace(String title, Range range, String replaceText, TextDocumentItem document, Diagnostic diagnostic) {
        TextEdit replace = new TextEdit(range, replaceText);
        return CodeActionFactory.replace(title, Collections.singletonList(replace), document, diagnostic);
    }

    public static CodeAction replace(String title, List<TextEdit> replace, TextDocumentItem document, Diagnostic diagnostic) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(Arrays.asList(diagnostic));
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, replace);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static CodeAction replaceAt(String title, String replaceText, TextDocumentItem document, Diagnostic diagnostic, Collection<Range> ranges) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(Arrays.asList(diagnostic));
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        for (Range range : ranges) {
            TextEdit edit = new TextEdit(range, replaceText);
            edits.add(edit);
        }
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, edits);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static CodeAction createFile(String title, String docURI, String content, Diagnostic diagnostic) {
        ArrayList<Either> actionsToTake = new ArrayList<Either>(2);
        actionsToTake.add(Either.forRight((Object)new CreateFile(docURI, new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)))));
        VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(docURI, Integer.valueOf(0));
        TextEdit te = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), content);
        actionsToTake.add(Either.forLeft((Object)new TextDocumentEdit(identifier, Collections.singletonList(te))));
        WorkspaceEdit createAndAddContentEdit = new WorkspaceEdit(actionsToTake);
        CodeAction codeAction = new CodeAction(title);
        codeAction.setEdit(createAndAddContentEdit);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        return codeAction;
    }

    public static CodeAction createCommand(String title, String commandId, List<Object> commandParams, Diagnostic diagnostic) {
        return CodeActionFactory.createCommand(title, commandId, commandParams, Collections.singletonList(diagnostic));
    }

    public static CodeAction createCommand(String title, String commandId, List<Object> commandParams, List<Diagnostic> diagnostics) {
        CodeAction codeAction = new CodeAction(title);
        Command command = new Command(title, commandId, commandParams);
        codeAction.setCommand(command);
        codeAction.setDiagnostics(diagnostics);
        codeAction.setKind("quickfix");
        codeAction.setEdit(new WorkspaceEdit());
        return codeAction;
    }

    public static CodeAction createCodeActionWithData(String title, Object data, List<Diagnostic> diagnostics) {
        CodeAction codeAction = new CodeAction(title);
        codeAction.setData(data);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(diagnostics);
        return codeAction;
    }

    public static boolean isDiagnosticCode(Either<String, Integer> diagnosticCode, String code) {
        if (diagnosticCode == null || diagnosticCode.isRight()) {
            return false;
        }
        return code.equals(diagnosticCode.getLeft());
    }
}

