/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons;

import com.redhat.qute.ls.commons.ModelTextDocument;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.ls.commons.TextDocuments;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;

public class ModelTextDocuments<T>
extends TextDocuments<ModelTextDocument<T>> {
    protected final BiFunction<TextDocument, CancelChecker, T> parse;

    public ModelTextDocuments(BiFunction<TextDocument, CancelChecker, T> parse) {
        this.parse = parse;
    }

    @Override
    public ModelTextDocument<T> createDocument(TextDocumentItem document) {
        ModelTextDocument<T> doc = new ModelTextDocument<T>(document, this.parse);
        doc.setIncremental(this.isIncremental());
        return doc;
    }

    public T getExistingModel(TextDocumentIdentifier documentIdentifier) {
        return this.getExistingModel(documentIdentifier.getUri());
    }

    public T getExistingModel(String uri) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.get(uri));
        if (document != null) {
            return document.getExistingModel();
        }
        return null;
    }

    public T getModel(TextDocumentIdentifier documentIdentifier) {
        return this.getModel(documentIdentifier.getUri());
    }

    public T getModel(String uri) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.get(uri));
        if (document != null) {
            return document.getModel();
        }
        return null;
    }

    public <R> CompletableFuture<R> computeModelAsync(TextDocumentIdentifier documentIdentifier, BiFunction<T, CancelChecker, R> code) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            T model = this.getModel(documentIdentifier);
            if (model == null) {
                return null;
            }
            cancelChecker.checkCanceled();
            return code.apply(model, (CancelChecker)cancelChecker);
        });
    }

    public <R> CompletableFuture<R> computeModelAsyncCompose(TextDocumentIdentifier documentIdentifier, BiFunction<T, CancelChecker, CompletableFuture<R>> code) {
        return ModelTextDocuments.computeAsyncCompose(cancelChecker -> {
            T model = this.getModel(documentIdentifier);
            if (model == null) {
                return null;
            }
            cancelChecker.checkCanceled();
            return (CompletableFuture)code.apply(model, (CancelChecker)cancelChecker);
        });
    }

    private static <R> CompletableFuture<R> computeAsyncCompose(Function<CancelChecker, CompletableFuture<R>> code) {
        CompletableFuture<CompletableFutures.FutureCancelChecker> start = new CompletableFuture<CompletableFutures.FutureCancelChecker>();
        CompletionStage result = start.thenComposeAsync(code);
        start.complete(new CompletableFutures.FutureCancelChecker((CompletableFuture)result));
        return result;
    }
}

