/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.services.LanguageServer;

public final class ParentProcessWatcher
implements Runnable,
Function<MessageConsumer, MessageConsumer> {
    private static final Logger LOGGER = Logger.getLogger(ParentProcessWatcher.class.getName());
    private static final boolean isJava1x = System.getProperty("java.version").startsWith("1.");
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    private static final int FORCED_EXIT_CODE = 1;
    private static final long INACTIVITY_DELAY_SECS = 30000L;
    private static final int POLL_DELAY_SECS = 10;
    private volatile long lastActivityTime;
    private final ProcessLanguageServer server;
    private final Function<MessageConsumer, MessageConsumer> wrapper;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService service;

    public ParentProcessWatcher(ProcessLanguageServer server, Function<MessageConsumer, MessageConsumer> wrapper) {
        this.server = server;
        this.wrapper = wrapper;
        this.service = Executors.newScheduledThreadPool(1);
        this.task = this.service.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.parentProcessStillRunning()) {
            LOGGER.warning("Parent process stopped running, forcing server exit");
            this.task.cancel(true);
            this.server.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parentProcessStillRunning() {
        long pid = this.server.getParentProcessId();
        if (pid == 0L || this.lastActivityTime > System.currentTimeMillis() - 30000L) {
            return true;
        }
        String command = isWindows ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
        Process process = null;
        boolean finished = false;
        try {
            process = Runtime.getRuntime().exec(command);
            finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroy();
                finished = process.waitFor(10L, TimeUnit.SECONDS);
            }
            if (isWindows && finished && process.exitValue() > 1) {
                LOGGER.warning("The tasklist command: '" + command + "' returns " + process.exitValue());
                boolean bl = true;
                return bl;
            }
            boolean bl = !finished || process.exitValue() == 0;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (process != null) {
                if (!finished) {
                    process.destroyForcibly();
                }
                if (isWindows) {
                    if (!isJava1x) {
                        Closeables.closeQuietly((InputStream)process.getInputStream());
                        Closeables.closeQuietly((InputStream)process.getErrorStream());
                        try {
                            Closeables.close((Closeable)process.getOutputStream(), (boolean)false);
                        }
                        catch (IOException iOException) {}
                    }
                    System.gc();
                }
            }
        }
    }

    @Override
    public MessageConsumer apply(MessageConsumer consumer) {
        return message -> {
            this.lastActivityTime = System.currentTimeMillis();
            this.wrapper.apply(consumer).consume(message);
        };
    }

    public static interface ProcessLanguageServer
    extends LanguageServer {
        public long getParentProcessId();

        public void exit(int var1);
    }
}

