/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons;

import com.redhat.qute.ls.commons.TextDocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;

public class TextDocuments<T extends TextDocument> {
    private final Map<String, T> documents = new HashMap<String, T>();
    private boolean incremental = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
        Map<String, T> map = this.documents;
        synchronized (map) {
            this.documents.values().forEach(document -> document.setIncremental(incremental));
        }
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String uri) {
        Map<String, T> map = this.documents;
        synchronized (map) {
            return (T)((Object)((TextDocument)((Object)this.documents.get(uri))));
        }
    }

    public T createDocument(TextDocumentItem document) {
        TextDocument doc = new TextDocument(document);
        doc.setIncremental(this.isIncremental());
        return (T)((Object)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T onDidChangeTextDocument(DidChangeTextDocumentParams params) {
        Map<String, T> map = this.documents;
        synchronized (map) {
            T document = this.getDocument((TextDocumentIdentifier)params.getTextDocument());
            if (document != null) {
                document.setVersion(params.getTextDocument().getVersion().intValue());
                ((TextDocument)((Object)document)).update(params.getContentChanges());
                return document;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T onDidOpenTextDocument(DidOpenTextDocumentParams params) {
        TextDocumentItem item = params.getTextDocument();
        Map<String, T> map = this.documents;
        synchronized (map) {
            T document = this.createDocument(item);
            this.documents.put(document.getUri(), document);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T onDidCloseTextDocument(DidCloseTextDocumentParams params) {
        Map<String, T> map = this.documents;
        synchronized (map) {
            T document = this.getDocument(params.getTextDocument());
            if (document != null) {
                this.documents.remove(params.getTextDocument().getUri());
            }
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T onDidSaveTextDocument(DidSaveTextDocumentParams params) {
        Map<String, T> map = this.documents;
        synchronized (map) {
            return this.getDocument(params.getTextDocument());
        }
    }

    private T getDocument(TextDocumentIdentifier identifier) {
        return (T)((Object)((TextDocument)((Object)this.documents.get(identifier.getUri()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> all() {
        Map<String, T> map = this.documents;
        synchronized (map) {
            return this.documents.values();
        }
    }
}

