/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons.snippets;

import com.redhat.qute.ls.commons.snippets.ISnippetContentProvider;
import com.redhat.qute.ls.commons.snippets.Snippet;
import java.util.List;
import java.util.Map;

public class DefaultSnippetContentProvider
implements ISnippetContentProvider {
    public static final ISnippetContentProvider INSTANCE = new DefaultSnippetContentProvider();

    @Override
    public String getInsertText(Snippet snippet, Map<String, String> model, boolean replace, String lineDelimiter, String whitespacesIndent) {
        StringBuilder text = new StringBuilder();
        List<String> body = snippet.getBody();
        for (int i = 0; i < body.size(); ++i) {
            String bodyLine = body.get(i);
            if (i > 0) {
                text.append(lineDelimiter);
                if (whitespacesIndent != null) {
                    text.append(whitespacesIndent);
                }
            }
            bodyLine = DefaultSnippetContentProvider.merge(bodyLine, model, replace);
            text.append(bodyLine);
        }
        return text.toString();
    }

    public static String merge(String line, Map<String, String> model, boolean replace) {
        return DefaultSnippetContentProvider.replace(line, 0, model, replace, null);
    }

    private static String replace(String line, int offset, Map<String, String> model, boolean replace, StringBuilder newLine) {
        char next;
        int dollarIndex = line.indexOf("$", offset);
        if (dollarIndex == -1 || dollarIndex == line.length() - 1) {
            if (newLine == null) {
                return line;
            }
            newLine.append(line, offset, line.length());
            return newLine.toString();
        }
        if (newLine == null) {
            newLine = new StringBuilder();
        }
        if (Character.isDigit(next = line.charAt(dollarIndex + 1))) {
            int lastDigitOffset;
            if (replace) {
                newLine.append(line, offset, dollarIndex);
            }
            for (lastDigitOffset = dollarIndex + 1; line.length() > lastDigitOffset && Character.isDigit(line.charAt(lastDigitOffset)); ++lastDigitOffset) {
            }
            if (!replace) {
                newLine.append(line, offset, lastDigitOffset);
            }
            return DefaultSnippetContentProvider.replace(line, lastDigitOffset, model, replace, newLine);
        }
        if (next == '{') {
            String paramName;
            int startExpr = dollarIndex;
            int endExpr = line.indexOf("}", startExpr);
            if (endExpr == -1) {
                return line;
            }
            newLine.append(line, offset, startExpr);
            int startParam = startExpr + 2;
            int endParam = endExpr;
            boolean startsWithNumber = true;
            boolean onlyNumber = true;
            for (int i = startParam; i < endParam; ++i) {
                char ch = line.charAt(i);
                if (!Character.isDigit(ch)) {
                    onlyNumber = false;
                    if (ch == ':') {
                        if (!startsWithNumber) break;
                        startParam = i + 1;
                        break;
                    }
                    if (ch != '|' || !startsWithNumber) break;
                    startParam = i + 1;
                    int index = line.indexOf(44, startExpr);
                    if (index == -1) break;
                    endParam = index;
                    break;
                }
                startsWithNumber = true;
            }
            if (model.containsKey(paramName = line.substring(startParam, endParam))) {
                paramName = model.get(paramName);
            } else if (!replace) {
                paramName = line.substring(startExpr, endExpr + 1);
            }
            if (!replace || !onlyNumber) {
                newLine.append(paramName);
            }
            return DefaultSnippetContentProvider.replace(line, endExpr + 1, model, replace, newLine);
        }
        return line;
    }
}

