/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.commons.snippets;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.redhat.qute.ls.commons.snippets.DefaultSnippetContentProvider;
import com.redhat.qute.ls.commons.snippets.ISnippetContentProvider;
import com.redhat.qute.ls.commons.snippets.ISnippetContext;
import com.redhat.qute.ls.commons.snippets.ISnippetRegistryLoader;
import com.redhat.qute.ls.commons.snippets.ISuffixPositionProvider;
import com.redhat.qute.ls.commons.snippets.Link;
import com.redhat.qute.ls.commons.snippets.Snippet;
import com.redhat.qute.ls.commons.snippets.SnippetDeserializer;
import com.redhat.qute.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SnippetRegistry<T extends Snippet> {
    private static final Logger LOGGER = Logger.getLogger(SnippetRegistry.class.getName());
    private final List<T> snippets = new ArrayList<T>();

    public SnippetRegistry() {
        this(null, true);
    }

    public SnippetRegistry(String languageId, boolean loadDefault) {
        if (loadDefault) {
            ServiceLoader<ISnippetRegistryLoader> loaders = ServiceLoader.load(ISnippetRegistryLoader.class);
            loaders.forEach(loader -> {
                if (Objects.equals(languageId, loader.getLanguageId())) {
                    try {
                        loader.load(this);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while consumming snippet loader " + loader.getClass().getName(), e);
                    }
                }
            });
        }
    }

    public void registerSnippet(T snippet) {
        if (this.isValid(snippet)) {
            this.snippets.add(snippet);
        }
    }

    private boolean isValid(T snippet) {
        return ((Snippet)snippet).getBody() != null;
    }

    public void registerSnippets(InputStream in) throws IOException {
        this.registerSnippets(in, null, null);
    }

    public void registerSnippets(InputStream in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(in, null, contextDeserializer);
    }

    public void registerSnippets(InputStream in, ISnippetContext<?> defaultContext) throws IOException {
        this.registerSnippets(in, defaultContext, null);
    }

    public void registerSnippets(InputStream in, ISnippetContext<?> defaultContext, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(new InputStreamReader(in, StandardCharsets.UTF_8.name()), defaultContext, contextDeserializer);
    }

    public void registerSnippets(Reader in) throws IOException {
        this.registerSnippets(in, null, null);
    }

    public void registerSnippets(Reader in, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        this.registerSnippets(in, null, contextDeserializer);
    }

    public void registerSnippets(Reader in, ISnippetContext<?> defaultContext) throws IOException {
        this.registerSnippets(in, defaultContext, null);
    }

    public void registerSnippets(Reader in, ISnippetContext<?> defaultContext, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws IOException {
        JsonReader reader = new JsonReader(in);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            Snippet snippet = (Snippet)SnippetRegistry.createSnippet(reader, contextDeserializer);
            if (snippet.getDescription() == null) {
                snippet.setDescription(name);
            }
            if (snippet.getContext() == null) {
                snippet.setContext(defaultContext);
            }
            this.registerSnippet(snippet);
        }
        reader.endObject();
    }

    private static <T> T createSnippet(JsonReader reader, TypeAdapter<? extends ISnippetContext<?>> contextDeserializer) throws JsonIOException, JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Snippet.class, (Object)new SnippetDeserializer(contextDeserializer));
        return (T)builder.create().fromJson(reader, Snippet.class);
    }

    public List<T> getSnippets() {
        return this.snippets;
    }

    public List<CompletionItem> getCompletionItems(Range replaceRange, String lineDelimiter, String whitespacesIndent, InsertTextMode defaultInsertTextMode, boolean canSupportMarkdown, boolean snippetsSupported, BiPredicate<ISnippetContext<?>, Map<String, String>> contextFilter, ISuffixPositionProvider suffixProvider, String suffixToFind, String prefixFilter) {
        return this.getCompletionItems(replaceRange, lineDelimiter, whitespacesIndent, defaultInsertTextMode, canSupportMarkdown, snippetsSupported, contextFilter, suffixProvider, suffixToFind, prefixFilter, DefaultSnippetContentProvider.INSTANCE);
    }

    public List<CompletionItem> getCompletionItems(Range replaceRange, String lineDelimiter, String whitespacesIndent, InsertTextMode defaultInsertTextMode, boolean canSupportMarkdown, boolean snippetsSupported, BiPredicate<ISnippetContext<?>, Map<String, String>> contextFilter, ISuffixPositionProvider suffixProvider, String suffixToFind, String prefixFilter, ISnippetContentProvider contentProvider) {
        if (replaceRange == null) {
            return Collections.emptyList();
        }
        HashMap model = new HashMap();
        return this.getSnippets().stream().filter(snippet -> snippet.match(contextFilter, model)).map(snippet -> {
            Position end;
            CompletionItem item = new CompletionItem();
            item.setLabel(snippet.getLabel());
            item.setKind(CompletionItemKind.Snippet);
            item.setDocumentation(Either.forRight((Object)SnippetRegistry.createDocumentation(snippet, model, canSupportMarkdown, lineDelimiter)));
            String prefix = snippet.getPrefixes().get(0);
            item.setFilterText(prefixFilter + prefix);
            item.setDetail(snippet.getDescription());
            Range range = replaceRange;
            String suffix = suffixToFind;
            if (suffix == null) {
                suffix = snippet.getSuffix();
            }
            if (!StringUtils.isEmpty(suffix) && suffixProvider != null && (end = suffixProvider.findSuffixPosition(suffix)) != null) {
                range = new Range(replaceRange.getStart(), end);
            }
            item.setInsertTextFormat(InsertTextFormat.Snippet);
            item.setSortText(snippet.getSortText());
            SnippetRegistry.updateInsertTextMode(item, whitespacesIndent, defaultInsertTextMode);
            String insertText = contentProvider.getInsertText((Snippet)snippet, model, !snippetsSupported, lineDelimiter, whitespacesIndent);
            item.setTextEdit(Either.forLeft((Object)new TextEdit(range, insertText)));
            return item;
        }).collect(Collectors.toList());
    }

    public static void updateInsertTextMode(CompletionItem item, String whitespacesIndent, InsertTextMode defaultInsertTextMode) {
        SnippetRegistry.updateInsertTextMode(item, whitespacesIndent == null ? InsertTextMode.AdjustIndentation : InsertTextMode.AsIs, defaultInsertTextMode);
    }

    private static void updateInsertTextMode(CompletionItem item, InsertTextMode insertTextMode, InsertTextMode defaultInsertTextMode) {
        if (defaultInsertTextMode != insertTextMode) {
            item.setInsertTextMode(insertTextMode);
        }
    }

    private static MarkupContent createDocumentation(Snippet snippet, Map<String, String> model, boolean canSupportMarkdown, String lineDelimiter) {
        StringBuilder doc = new StringBuilder();
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            String scope = snippet.getScope();
            if (scope != null) {
                doc.append(scope);
            }
            doc.append(System.lineSeparator());
        }
        String insertText = DefaultSnippetContentProvider.INSTANCE.getInsertText(snippet, model, true, lineDelimiter, null);
        doc.append(insertText);
        if (canSupportMarkdown) {
            doc.append(System.lineSeparator());
            doc.append("```");
            doc.append(System.lineSeparator());
        }
        SnippetRegistry.addLinks(snippet.getLinks(), doc, canSupportMarkdown);
        return new MarkupContent(canSupportMarkdown ? "markdown" : "plaintext", doc.toString());
    }

    public static void addLinks(List<Link> links, StringBuilder documentation, boolean canSupportMarkdown) {
        if (links != null && !links.isEmpty()) {
            documentation.append(System.lineSeparator());
            documentation.append(System.lineSeparator());
            documentation.append("See ");
            if (links.size() == 1) {
                Link link = links.get(0);
                SnippetRegistry.addLink(link.getUrl(), link.getLabel(), documentation, canSupportMarkdown);
                documentation.append(" for more information.");
            } else {
                documentation.append("for more information:");
                for (int i = 0; i < links.size(); ++i) {
                    Link link = links.get(i);
                    documentation.append(System.lineSeparator());
                    documentation.append(" * ");
                    SnippetRegistry.addLink(link.getUrl(), link.getLabel(), documentation, canSupportMarkdown);
                }
            }
        }
    }

    public static void addLink(String url, String label, StringBuilder documentation, boolean canSupportMarkdown) {
        if (canSupportMarkdown) {
            documentation.append("[");
            documentation.append(label);
            documentation.append("](");
            documentation.append(url);
            documentation.append(")");
        } else {
            documentation.append(url);
        }
    }
}

