/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.java;

import com.redhat.qute.commons.QuteJavaCodeLensParams;
import com.redhat.qute.commons.QuteJavaDiagnosticsParams;
import com.redhat.qute.commons.QuteJavaDocumentLinkParams;
import com.redhat.qute.ls.AbstractTextDocumentService;
import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.ls.commons.TextDocument;
import com.redhat.qute.ls.commons.TextDocuments;
import com.redhat.qute.ls.commons.ValidatorDelayer;
import com.redhat.qute.settings.SharedSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class JavaFileTextDocumentService
extends AbstractTextDocumentService {
    private final TextDocuments<TextDocument> textDocuments = new TextDocuments();
    private final ValidatorDelayer<TextDocument> validatorDelayer = new ValidatorDelayer<TextDocument>(textDocument -> this.triggerValidationFor((TextDocument)((Object)textDocument)));

    public JavaFileTextDocumentService(QuteLanguageServer quteLanguageServer, SharedSettings sharedSettings) {
        super(quteLanguageServer, sharedSettings);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        TextDocument textDocument = this.textDocuments.onDidOpenTextDocument(params);
        this.validate(textDocument, false);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        TextDocument textDocument = this.textDocuments.onDidChangeTextDocument(params);
        this.validate(textDocument, true);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        TextDocument textDocument = this.textDocuments.onDidCloseTextDocument(params);
        this.quteLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(textDocument.getUri(), new ArrayList()));
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void updateClientCapabilities(ClientCapabilities capabilities) {
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (!this.sharedSettings.getCodeLensSettings().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        QuteJavaCodeLensParams javaParams = new QuteJavaCodeLensParams(params.getTextDocument().getUri());
        return this.quteLanguageServer.getLanguageClient().getJavaCodelens(javaParams);
    }

    @Override
    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        QuteJavaDocumentLinkParams javaParams = new QuteJavaDocumentLinkParams(params.getTextDocument().getUri());
        return this.quteLanguageServer.getLanguageClient().getJavaDocumentLink(javaParams);
    }

    private void validate(TextDocument textDocument, boolean delay) {
        if (delay) {
            this.validatorDelayer.validateWithDelay(textDocument);
        } else {
            this.triggerValidationFor(textDocument);
        }
    }

    private void triggerValidationFor(TextDocument textDocument) {
        this.triggerValidationFor(Arrays.asList(textDocument));
    }

    private void triggerValidationFor(List<TextDocument> textDocuments) {
        if (textDocuments.isEmpty()) {
            return;
        }
        List<String> uris = textDocuments.stream().map(textDocument -> textDocument.getUri()).collect(Collectors.toList());
        QuteJavaDiagnosticsParams params = new QuteJavaDiagnosticsParams(uris);
        this.quteLanguageServer.getLanguageClient().getJavaDiagnostics(params).thenApply(diagnostics -> {
            if (diagnostics == null) {
                return null;
            }
            for (PublishDiagnosticsParams diagnostic : diagnostics) {
                this.quteLanguageServer.getLanguageClient().publishDiagnostics(diagnostic);
            }
            return null;
        });
    }

    @Override
    public AbstractTextDocumentService.FileType getFileType() {
        return AbstractTextDocumentService.FileType.JAVA;
    }

    public void dispose() {
        this.validatorDelayer.dispose();
    }
}

