/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.ls.template;

import com.redhat.qute.commons.TelemetryEvent;
import com.redhat.qute.commons.datamodel.JavaDataModelChangeEvent;
import com.redhat.qute.ls.AbstractTextDocumentService;
import com.redhat.qute.ls.QuteLanguageServer;
import com.redhat.qute.ls.api.QuteLanguageClientAPI;
import com.redhat.qute.ls.api.QuteTemplateProvider;
import com.redhat.qute.ls.commons.ModelTextDocument;
import com.redhat.qute.ls.commons.ValidatorDelayer;
import com.redhat.qute.parser.template.Template;
import com.redhat.qute.parser.template.TemplateParser;
import com.redhat.qute.project.QuteProject;
import com.redhat.qute.project.QuteTextDocument;
import com.redhat.qute.project.documents.QuteOpenedTextDocument;
import com.redhat.qute.project.documents.QuteOpenedTextDocuments;
import com.redhat.qute.project.documents.TemplateValidator;
import com.redhat.qute.services.QuteLanguageService;
import com.redhat.qute.services.ResolvingJavaTypeContext;
import com.redhat.qute.settings.SharedSettings;
import com.redhat.qute.utils.QutePositionUtility;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class TemplateFileTextDocumentService
extends AbstractTextDocumentService
implements QuteTemplateProvider,
TemplateValidator {
    private final QuteOpenedTextDocuments documents;
    private ValidatorDelayer<ModelTextDocument<Template>> validatorDelayer;
    private final QuteLanguageServer languageServer;
    private boolean hasOpenedAQuteDocument;

    public TemplateFileTextDocumentService(QuteLanguageServer quteLanguageServer, SharedSettings sharedSettings) {
        super(quteLanguageServer, sharedSettings);
        this.documents = new QuteOpenedTextDocuments((document, cancelChecker) -> TemplateParser.parse(document, () -> cancelChecker.checkCanceled()), quteLanguageServer, quteLanguageServer.getProjectRegistry());
        this.validatorDelayer = new ValidatorDelayer<ModelTextDocument>(template -> this.triggerValidationFor((QuteTextDocument)((Object)template)));
        this.languageServer = quteLanguageServer;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        QuteProject project;
        QuteOpenedTextDocument document = (QuteOpenedTextDocument)this.documents.onDidOpenTextDocument(params);
        if (!this.hasOpenedAQuteDocument) {
            this.hasOpenedAQuteDocument = true;
            this.getLanguageClient().telemetryEvent(new TelemetryEvent("qute.file.opened", new HashMap()));
        }
        if ((project = document.getProject()) != null) {
            this.triggerValidationFor(document);
        } else {
            document.getProjectInfoFuture().thenAccept(projectInfo -> {
                if (projectInfo != null) {
                    this.triggerValidationFor(document);
                }
            });
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        QuteOpenedTextDocument document = (QuteOpenedTextDocument)this.documents.onDidChangeTextDocument(params);
        this.validatorDelayer.validateWithDelay(document);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documents.onDidCloseTextDocument(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.documents.onDidSaveTextDocument(params);
    }

    @Override
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().doComplete((Template)template, params.getPosition(), this.sharedSettings.getCompletionSettings(), this.sharedSettings.getFormattingSettings(), this.sharedSettings.getNativeSettings(), (CancelChecker)cancelChecker).thenApply(list -> Either.forRight((Object)list)));
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (!this.sharedSettings.getCodeLensSettings().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().getCodeLens((Template)template, this.sharedSettings, (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        if (this.validatorDelayer.isRevalidating(params.getTextDocument().getUri())) {
            return CompletableFuture.completedFuture(Collections.EMPTY_LIST);
        }
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().doCodeActions((Template)template, params.getContext(), this.getLanguageClient(), params.getRange(), this.sharedSettings).thenApply(codeActions -> {
            cancelChecker.checkCanceled();
            return codeActions.stream().map(ca -> {
                Either e = Either.forRight((Object)ca);
                return e;
            }).collect(Collectors.toList());
        }));
    }

    @Override
    public CompletableFuture<Hover> hover(HoverParams params) {
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().doHover((Template)template, params.getPosition(), this.sharedSettings, (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return this.getTemplate(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().findDocumentHighlights((Template)template, params.getPosition(), (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().findDefinition((Template)template, params.getPosition(), (CancelChecker)cancelChecker).thenApply(definitions -> {
            cancelChecker.checkCanceled();
            if (super.isDefinitionLinkSupport()) {
                return Either.forRight((Object)definitions);
            }
            List locations = definitions.stream().map(locationLink -> QutePositionUtility.toLocation(locationLink)).collect(Collectors.toList());
            return Either.forLeft(locations);
        }));
    }

    @Override
    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().findDocumentLinks((Template)template, (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        return this.getTemplate(params.getTextDocument(), (template, cancelChecker) -> {
            if (super.isHierarchicalDocumentSymbolSupport()) {
                return this.getQuteLanguageService().findDocumentSymbols((Template)template, (CancelChecker)cancelChecker).stream().map(s -> {
                    Either e = Either.forRight((Object)s);
                    return e;
                }).collect(Collectors.toList());
            }
            return this.getQuteLanguageService().findSymbolInformations((Template)template, (CancelChecker)cancelChecker).stream().map(s -> {
                Either e = Either.forLeft((Object)s);
                return e;
            }).collect(Collectors.toList());
        });
    }

    @Override
    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.getTemplate(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().findReferences((Template)template, params.getPosition(), params.getContext(), (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.getTemplate(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().doRename((Template)template, params.getPosition(), params.getNewName(), (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<LinkedEditingRanges> linkedEditingRange(LinkedEditingRangeParams params) {
        return this.getTemplate(params.getTextDocument(), (template, cancelChecker) -> this.getQuteLanguageService().findLinkedEditingRanges((Template)template, params.getPosition(), (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        if (!this.sharedSettings.getInlayHintSettings().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.getTemplateCompose(params.getTextDocument(), (template, cancelChecker) -> {
            ResolvingJavaTypeContext resolvingJavaTypeContext = new ResolvingJavaTypeContext((Template)template);
            CompletableFuture<List<InlayHint>> hints = this.getQuteLanguageService().getInlayHint((Template)template, params.getRange(), this.sharedSettings, resolvingJavaTypeContext, (CancelChecker)cancelChecker);
            if (!resolvingJavaTypeContext.isEmpty()) {
                CompletableFuture<Void> allFutures = CompletableFuture.allOf(resolvingJavaTypeContext.toArray(new CompletableFuture[resolvingJavaTypeContext.size()]));
                return allFutures.thenCompose(Void2 -> {
                    cancelChecker.checkCanceled();
                    return this.inlayHint(params);
                });
            }
            return hints;
        });
    }

    @Override
    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction codeAction) {
        return this.getQuteLanguageService().resolveCodeAction(codeAction, this.getLanguageClient());
    }

    private QuteLanguageService getQuteLanguageService() {
        return this.quteLanguageServer.getQuteLanguageService();
    }

    public QuteOpenedTextDocument getDocument(String uri) {
        return (QuteOpenedTextDocument)this.documents.get(uri);
    }

    public <R> CompletableFuture<R> getTemplate(TextDocumentIdentifier documentIdentifier, BiFunction<Template, CancelChecker, R> code) {
        return this.documents.computeModelAsync(documentIdentifier, code);
    }

    public <R> CompletableFuture<R> getTemplateCompose(TextDocumentIdentifier documentIdentifier, BiFunction<Template, CancelChecker, CompletableFuture<R>> code) {
        return this.documents.computeModelAsyncCompose(documentIdentifier, code);
    }

    public void validationSettingsChanged() {
        this.validateAllTemplates();
    }

    public void dataModelChanged(JavaDataModelChangeEvent event) {
        this.validateAllTemplates();
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.languageServer.getProjectRegistry().didChangeWatchedFiles(params);
    }

    @Override
    public void triggerValidationFor(QuteTextDocument document) {
        Template template = document.getTemplate();
        ResolvingJavaTypeContext resolvingJavaTypeContext = new ResolvingJavaTypeContext(template);
        List<Diagnostic> diagnostics = this.getQuteLanguageService().doDiagnostics(template, this.getSharedSettings().getValidationSettings(template.getUri()), this.getSharedSettings().getNativeSettings(), resolvingJavaTypeContext, () -> template.checkCanceled());
        template.checkCanceled();
        this.quteLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(template.getUri(), diagnostics));
        if (!resolvingJavaTypeContext.isEmpty()) {
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(resolvingJavaTypeContext.toArray(new CompletableFuture[resolvingJavaTypeContext.size()]));
            allFutures.thenAccept(Void2 -> this.triggerValidationFor(document));
        }
    }

    @Override
    public void clearDiagnosticsFor(String fileUri) {
        this.quteLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(fileUri, Collections.emptyList()));
    }

    private void validateAllTemplates() {
        Collection<QuteProject> projects = this.languageServer.getProjectRegistry().getProjects();
        if (projects.isEmpty()) {
            this.documents.all().stream().forEach(document -> this.triggerValidationFor((QuteOpenedTextDocument)document));
        } else {
            this.triggerValidationFor(projects);
        }
    }

    @Override
    public void triggerValidationFor(Collection<QuteProject> projects) {
        for (QuteProject project : projects) {
            this.documents.all().stream().forEach(document -> {
                QuteProject documentProject = ((Template)document.getModel()).getProject();
                if (project.equals(documentProject)) {
                    this.triggerValidationFor((QuteOpenedTextDocument)document);
                }
            });
            project.validateClosedTemplates();
        }
    }

    private QuteLanguageClientAPI getLanguageClient() {
        return this.languageServer.getLanguageClient();
    }

    @Override
    public AbstractTextDocumentService.FileType getFileType() {
        return AbstractTextDocumentService.FileType.TEMPLATE;
    }

    @Override
    public Template getTemplate(String uri) {
        QuteOpenedTextDocument document = this.getDocument(uri);
        return document != null ? document.getModel() : null;
    }

    public void dispose() {
        this.validatorDelayer.dispose();
    }
}

