/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.condition;

import com.redhat.qute.parser.parameter.ParameterParser;
import com.redhat.qute.parser.template.Parameter;
import com.redhat.qute.parser.template.ParametersContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConditionExpression {
    private final int start;
    private final int end;
    private final ParametersContainer container;
    private final List<Integer> offsets;

    public ConditionExpression(int start, int end, ParametersContainer container, Object object) {
        this.start = start;
        this.end = end;
        this.container = container;
        this.offsets = new ArrayList<Integer>();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setStartBracket(int startBracket) {
        this.offsets.add(startBracket);
    }

    public void setEndBracket(int endBracket) {
        this.offsets.add(endBracket);
    }

    public List<Parameter> getAllParameters() {
        if (this.offsets.isEmpty()) {
            return this.parseParameters(this.start, this.end);
        }
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>();
        int start = this.start;
        for (Integer offset : this.offsets) {
            allParameters.addAll(this.parseParameters(start, offset));
            start = offset;
        }
        allParameters.addAll(this.parseParameters(start, this.end));
        return allParameters;
    }

    public List<Parameter> parseParameters(int start, int end) {
        String text = this.container.getTemplateContent();
        char bracket = text.charAt(start);
        if (bracket == '(' || bracket == ')') {
            ++start;
        }
        if (start >= end) {
            return Collections.emptyList();
        }
        return ParameterParser.parse(start, end, this.container, false, false);
    }
}

