/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.condition;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.condition.ConditionExpression;
import com.redhat.qute.parser.condition.scanner.ConditionScanner;
import com.redhat.qute.parser.condition.scanner.TokenType;
import com.redhat.qute.parser.template.ParametersContainer;

public class ConditionParser {
    private static CancelChecker DEFAULT_CANCEL_CHECKER = () -> {};

    public static ConditionExpression parse(ParametersContainer container, CancelChecker cancelChecker) {
        if (cancelChecker == null) {
            cancelChecker = DEFAULT_CANCEL_CHECKER;
        }
        String text = container.getTemplateContent();
        int start = container.getStartParametersOffset();
        int end = container.getEndParametersOffset();
        ConditionScanner scanner = ConditionScanner.createScanner(text, start, end);
        TokenType token = (TokenType)((Object)scanner.scan());
        ConditionExpression currentCondition = new ConditionExpression(start, end, container, null);
        while (token != TokenType.EOS) {
            cancelChecker.checkCanceled();
            int tokenOffset = scanner.getTokenOffset();
            switch (token) {
                case StartBracketCondition: {
                    currentCondition.setStartBracket(tokenOffset);
                    break;
                }
                case EndBracketCondition: {
                    currentCondition.setEndBracket(tokenOffset);
                    break;
                }
            }
            token = (TokenType)((Object)scanner.scan());
        }
        return currentCondition;
    }
}

