/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.CancelChecker;
import com.redhat.qute.parser.expression.InfixNotationMethodPart;
import com.redhat.qute.parser.expression.MethodPart;
import com.redhat.qute.parser.expression.NamespacePart;
import com.redhat.qute.parser.expression.ObjectPart;
import com.redhat.qute.parser.expression.Parts;
import com.redhat.qute.parser.expression.PropertyPart;
import com.redhat.qute.parser.expression.scanner.ExpressionScanner;
import com.redhat.qute.parser.expression.scanner.TokenType;
import com.redhat.qute.parser.template.Expression;
import com.redhat.qute.parser.template.Node;
import com.redhat.qute.parser.template.Template;
import java.util.ArrayList;
import java.util.List;

public class ExpressionParser {
    private static CancelChecker DEFAULT_CANCEL_CHECKER = () -> {};

    public static List<Node> parse(Expression expression, boolean canSupportInfixNotation, CancelChecker cancelChecker) {
        if (cancelChecker == null) {
            cancelChecker = DEFAULT_CANCEL_CHECKER;
        }
        Template template = expression.getOwnerTemplate();
        String text = template.getText();
        int start = expression.getStartContentOffset();
        int end = expression.getEndContentOffset();
        ExpressionScanner scanner = ExpressionScanner.createScanner(text, canSupportInfixNotation, start, end);
        TokenType token = (TokenType)((Object)scanner.scan());
        ArrayList<Node> expressionContent = new ArrayList<Node>();
        Node currentParts = null;
        while (token != TokenType.EOS) {
            cancelChecker.checkCanceled();
            int tokenOffset = scanner.getTokenOffset();
            int tokenEnd = scanner.getTokenEnd();
            switch (token) {
                case Whitespace: {
                    if (canSupportInfixNotation) break;
                    currentParts = null;
                    break;
                }
                case NamespacePart: {
                    currentParts = new Parts(tokenOffset, tokenEnd);
                    ((Parts)currentParts).setExpressionParent(expression);
                    expressionContent.add(currentParts);
                    NamespacePart namespacePart = new NamespacePart(tokenOffset, tokenEnd);
                    ((Parts)currentParts).addPart(namespacePart);
                    break;
                }
                case ObjectPart: {
                    if (currentParts == null || currentParts.getChildCount() != 1 || ((Parts)currentParts).getChild(0).getPartKind() != Parts.PartKind.Namespace) {
                        currentParts = new Parts(tokenOffset, tokenEnd);
                        ((Parts)currentParts).setExpressionParent(expression);
                        expressionContent.add(currentParts);
                    }
                    if (currentParts == null) break;
                    ObjectPart objectPart = new ObjectPart(tokenOffset, tokenEnd);
                    ((Parts)currentParts).addPart(objectPart);
                    break;
                }
                case PropertyPart: {
                    if (currentParts == null) break;
                    PropertyPart propertyPart = new PropertyPart(tokenOffset, tokenEnd);
                    ((Parts)currentParts).addPart(propertyPart);
                    break;
                }
                case MethodPart: {
                    if (currentParts == null) break;
                    MethodPart methodPart = new MethodPart(tokenOffset, tokenEnd);
                    ((Parts)currentParts).addPart(methodPart);
                    break;
                }
                case InfixMethodPart: {
                    if (currentParts == null) break;
                    MethodPart methodPart = new InfixNotationMethodPart(tokenOffset, tokenEnd);
                    ((Parts)currentParts).addPart(methodPart);
                    break;
                }
                case Dot: {
                    if (currentParts == null) break;
                    ((Parts)currentParts).addDot(tokenOffset);
                    break;
                }
                case ColonSpace: {
                    if (currentParts == null) break;
                    ((Parts)currentParts).addColonSpace(tokenOffset);
                    break;
                }
                case OpenBracket: {
                    Node last;
                    if (currentParts == null || !((last = currentParts.getLastChild()) instanceof MethodPart)) break;
                    ((MethodPart)last).setOpenBracket(tokenOffset);
                    break;
                }
                case CloseBracket: {
                    Node last;
                    if (currentParts == null || !((last = currentParts.getLastChild()) instanceof MethodPart)) break;
                    ((MethodPart)last).setCloseBracket(tokenOffset);
                    break;
                }
                case InfixParameter: 
                case StartString: 
                case String: 
                case EndString: {
                    ExpressionParser.adjustEndOfInfixNotationMethod((Parts)currentParts, scanner, tokenEnd);
                    break;
                }
                default: {
                    currentParts = null;
                }
            }
            token = (TokenType)((Object)scanner.scan());
        }
        if (currentParts != null) {
            Node last = currentParts.getLastChild();
            int endParts = currentParts.getEnd();
            char c = text.charAt(endParts - 1);
            if (c != '.') {
                ((Parts)currentParts).setEnd(end);
                if (last instanceof MethodPart && !last.isClosed()) {
                    ((MethodPart)last).setEnd(end);
                }
            }
        }
        return expressionContent;
    }

    public static void adjustEndOfInfixNotationMethod(Parts currentParts, ExpressionScanner scanner, int tokenEnd) {
        Node last;
        if (currentParts != null && (last = currentParts.getLastChild()) instanceof MethodPart) {
            MethodPart methodPart = (MethodPart)last;
            methodPart.setEnd(tokenEnd);
        }
    }
}

