/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.parser.expression;

import com.redhat.qute.parser.expression.MethodPart;
import java.util.HashMap;
import java.util.Map;

public class InfixNotationMethodPart
extends MethodPart {
    private static final String ELVIS_OPERATOR = "?:";
    private static final String OR_OPERATOR = "or";
    private static final Map<String, String> operators = new HashMap<String, String>();

    public InfixNotationMethodPart(int start, int end) {
        super(start, end);
    }

    @Override
    public boolean hasOpenBracket() {
        return true;
    }

    @Override
    public boolean hasCloseBracket() {
        return true;
    }

    @Override
    public int getStartParametersOffset() {
        return super.getEndName() + 1;
    }

    @Override
    public int getEndParametersOffset() {
        return super.getEnd();
    }

    @Override
    public boolean isInfixNotation() {
        return true;
    }

    @Override
    public boolean isOperator() {
        return operators.containsKey(this.getPartName());
    }

    @Override
    public boolean isOrOperator() {
        String partName = this.getPartName();
        return ELVIS_OPERATOR.equals(partName) || OR_OPERATOR.equals(partName);
    }

    static {
        operators.put(ELVIS_OPERATOR, OR_OPERATOR);
        operators.put("?", "ifTruthy");
        operators.put(":", null);
        operators.put("&&", null);
        operators.put("||", null);
    }
}

